import {
  CheckOutlined,
  DeleteOutlined,
  EditOutlined,
  FilterOutlined,
  SearchOutlined,
  SortAscendingOutlined,
  UndoOutlined,
} from "@ant-design/icons";
import {
  Button,
  ConfigProvider,
  Input,
  Layout,
  Space,
  type ThemeConfig,
} from "antd";

import { Background } from "../Shared";
import { CardDetail } from "./CardDetail";
import { DeckSelect } from "./DeckSelect";
import styles from "./index.module.scss";

const { Content, Sider } = Layout;

const theme: ThemeConfig = {
  components: {
    Layout: {
      colorBgBody: "transparent",
    },
  },
};

export const Component: React.FC = () => {
  return (
    <ConfigProvider theme={theme}>
      <Background />
      <Layout className={styles.layout} style={{ width: "100%" }}>
        <Sider width={300} className={styles.sider}>
          <DeckSelect
            decks={Array.from({ length: 17 }).map((_, i) => ({
              name: `卡组 ${i}`,
              id: i,
            }))}
            selected={4}
            onSelect={(id) => console.log(id)}
            onDelete={(id) => console.log(id)}
            onDownload={(id) => console.log(id)}
            onAdd={() => console.log("add")}
          />
          <CardDetail code={123} open={false} onClose={() => {}} />
        </Sider>
        <Content className={styles.content}>
          <Deck />
          <CardSelect />
        </Content>
      </Layout>
    </ConfigProvider>
  );
};
Component.displayName = "Build";

const Deck: React.FC = () => {
  return (
    <div className={styles.deck}>
      <div className={styles.container}>
        <Space
          className={styles.title}
          style={{ justifyContent: "space-between" }}
        >
          <Input
            placeholder="我的卡组"
            bordered={false}
            prefix={<EditOutlined />}
          />
          <Space style={{ marginRight: 6 }}>
            <Button type="text" size="small" icon={<DeleteOutlined />}>
              清空
            </Button>
            <Button type="text" size="small" icon={<UndoOutlined />}>
              重置
            </Button>
            <Button type="text" size="small" icon={<CheckOutlined />}>
              保存
            </Button>
          </Space>
        </Space>
        <div className={styles["deck-zone"]}>
          <div className={styles.main}>
            <div className={styles["card-continer"]}>
              {Array.from({ length: 60 }).map((_, i) => (
                <div className={styles.card} key={i} />
              ))}
            </div>
          </div>
          <div className={styles.extra}>
            <div className={styles["card-continer"]}>
              {Array.from({ length: 15 }).map((_, i) => (
                <div className={styles.card} key={i} />
              ))}
            </div>
          </div>
          <div className={styles.side}>
            <div className={styles["card-continer"]}>
              {Array.from({ length: 15 }).map((_, i) => (
                <div className={styles.card} key={i} />
              ))}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

const CardSelect: React.FC = () => {
  return (
    <div className={styles.select}>
      <div className={styles.container}>
        <div className={styles.title}>
          <Input
            placeholder="搜索卡片"
            bordered={false}
            suffix={<Button type="text" icon={<SearchOutlined />} />}
          />
        </div>
        <div className={styles["select-btns"]}>
          <Button block type="text" icon={<FilterOutlined />}>
            筛选
          </Button>
          <Button block type="text" icon={<SortAscendingOutlined />}>
            排列
          </Button>
          <Button block type="text" icon={<DeleteOutlined />}>
            重置
          </Button>
        </div>
        <div className={styles["search-cards-container"]}>
          <div className={styles["search-cards"]}>
            {Array.from({ length: 60 }).map((_, i) => (
              <div className={styles.card} key={i} />
            ))}
          </div>
        </div>
      </div>
    </div>
  );
};
