import { NavLink, Outlet } from "react-router-dom";

import { useConfig } from "@/config";

const NeosConfig = useConfig();
import styles from "./index.module.scss";

export const NeosLayout = () => {
  return (
    <>
      <nav className={styles.navbar}>
        <img
          className={styles.logo}
          src={`${NeosConfig.assetsPath}/neos_logo.png`}
          alt="NEOS"
        />

        <NavLink to="/">主页</NavLink>
        <NavLink to="/match">匹配</NavLink>
        <NavLink to="/build">组卡</NavLink>
        <span style={{ flexGrow: 1 }} />
        <NavLink to="/home">我的</NavLink>
      </nav>
      <Outlet />
    </>
  );
};
