import {
  Button,
  Checkbox,
  Form,
  Input,
  InputNumber,
  Select,
  type SelectProps,
} from "antd";

import styles from "./Filter.module.scss";

const options: SelectProps["options"] = [];

for (let i = 10; i < 36; i++) {
  options.push({
    label: i.toString(36) + i,
    value: i.toString(36) + i,
  });
}

export const Filter: React.FC = () => {
  return (
    <>
      <div className={styles.title}>卡片筛选</div>
      <div className={styles.form}>
        <div className={styles.item}>
          <div className={styles["item-name"]}>卡种</div>
          <Select
            mode="multiple"
            allowClear
            style={{ width: "100%" }}
            placeholder="Please select"
            options={options}
          />
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>属性</div>
          <Select
            mode="multiple"
            allowClear
            style={{ width: "100%" }}
            placeholder="Please select"
            options={options}
          />
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>星级</div>
          <Select
            mode="multiple"
            allowClear
            style={{ width: "100%" }}
            placeholder="Please select"
            options={options}
          />
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>种族</div>
          <Select
            mode="multiple"
            allowClear
            style={{ width: "100%" }}
            placeholder="Please select"
            options={options}
          />
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>类型</div>
          <Select
            mode="multiple"
            allowClear
            style={{ width: "100%" }}
            placeholder="Please select"
            options={options}
          />
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>其他</div>
          <Select
            mode="multiple"
            allowClear
            style={{ width: "100%" }}
            placeholder="Please select"
            options={options}
          />
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>攻击力</div>
          <div className={styles.number}>
            <InputNumber min={1} max={10} defaultValue={3} />
            <span className={styles.divider}>~</span>
            <InputNumber min={1} max={10} defaultValue={3} />
          </div>
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>防御力</div>
          <div className={styles.number}>
            <InputNumber min={1} max={10} defaultValue={3} />
            <span className={styles.divider}>~</span>
            <InputNumber min={1} max={10} defaultValue={3} />
          </div>
        </div>
      </div>
      <div className={styles.btns}>
        <Button type="primary">确定</Button>
        <Button type="text">取&nbsp;消</Button>
      </div>
    </>
  );
};
