import { LineOutlined } from "@ant-design/icons";
import { Button } from "antd";
import classNames from "classnames";

import styles from "./CardDetail.module.scss";

export const CardDetail: React.FC<{
  code: number;
  open: boolean;
  onClose: () => void;
}> = ({ code, open, onClose }) => {
  code;
  return (
    <div className={classNames(styles.detail, { [styles.open]: open })}>
      <div className={styles.container}>
        <Button
          className={styles["btn-close"]}
          icon={<LineOutlined />}
          type="text"
          onClick={onClose}
        />
      </div>
    </div>
  );
};
