import { Button } from "antd";
import styles from "./CardDetail.module.scss";
import { LineOutlined } from "@ant-design/icons";
import classNames from "classnames";

export const CardDetail: React.FC<{
  code: number;
  open: boolean;
  onClose: () => void;
}> = ({ code, open, onClose }) => {
  return (
    <div className={classNames(styles.detail, { [styles.open]: open })}>
      <div className={styles.container}>
        <Button
          className={styles["btn-close"]}
          icon={<LineOutlined />}
          type="text"
          onClick={onClose}
        />
      </div>
    </div>
  );
};
