import {
  DeleteOutlined,
  DownloadOutlined,
  PlusOutlined,
} from "@ant-design/icons";
import { Button } from "antd";

import styles from "./DeckSelect.module.scss";

export const DeckSelect: React.FC<{
  decks: { name: string; id: number }[];
  selected: number;
  onSelect: (id: number) => void;
  onDelete: (id: number) => void;
  onDownload: (id: number) => void;
  onAdd: () => void;
}> = ({ decks, selected, onSelect, onDelete, onDownload, onAdd }) => {
  return (
    <>
      <div className={styles["deck-select"]}>
        {decks.map(({ name, id }) => (
          <div key={id} className={styles.item} onClick={() => onSelect(id)}>
            <div className={styles.hover} />
            {selected === id && <div className={styles.selected} />}
            <span>{name}</span>
            <div className={styles.btns}>
              <Button
                icon={<DeleteOutlined />}
                type="text"
                shape="circle"
                onClick={cancelBubble(() => onDelete(id))}
              />
              <Button
                icon={<DownloadOutlined />}
                type="text"
                shape="circle"
                onClick={cancelBubble(() => onDownload(id))}
              />
            </div>
          </div>
        ))}
      </div>
      <Button
        className={styles["btn-add"]}
        icon={<PlusOutlined />}
        shape="circle"
        type="text"
        onClick={onAdd}
      />
    </>
  );
};

/** 阻止事件冒泡 */
const cancelBubble =
  <T,>(fn: (e: React.SyntheticEvent) => T) =>
  (e: React.SyntheticEvent) => {
    e.stopPropagation();
    e.nativeEvent.stopImmediatePropagation();
    return fn(e);
  };
