import { useEffect } from "react";
import { createRoot } from "react-dom/client";
import { withPortalToBody } from "@/ui/Shared";

import styles from "./index.module.scss";
import classNames from "classnames";
import { matStore, isMe } from "@/stores";
import { useSnapshot } from "valtio";

export const Underlying: React.FC<{}> = withPortalToBody(() => {
  const { currentPlayer } = useSnapshot(matStore);
  return (
    <div
      className={classNames(styles.background, {
        [styles.opponent]: !isMe(currentPlayer),
      })}
    >
      <div className={styles.inner}></div>
    </div>
  );
});
