import axios from "axios";

const API_URL = "https://sapi.moecube.com:444/ygopro/match";

interface MatchInfo {
  ip: string;
  port: number;
  password: string;
}

export async function match(
  userName: string,
  extraId: number,
  arena: string = "entertain"
): Promise<MatchInfo | undefined> {
  const headers = { Authorization: "Basic " + btoa(userName + ":" + extraId) };
  const response = await axios
    .post(API_URL, undefined, {
      headers: headers,
      params: {
        arena,
        // TODO: locale?
      },
    })
    .catch((error) => {
      console.error(`match error: ${error}`);

      return undefined;
    });

  return response ? JSON.parse(response.data) : undefined;
}
