import { RightOutlined } from "@ant-design/icons";
import React from "react";
import { Link } from "react-router-dom";

import { useConfig } from "@/config";

import styles from "./index.module.scss";

const NeosConfig = useConfig();

const Start: React.FC = () => {
  return (
    <>
      <div className={styles.wrapper}>
        <div className={styles["particles-container"]}>
          {Array.from({ length: 100 }).map((_, key) => (
            <div key={key} className={styles["particle-container"]}>
              <div className={styles["particle"]} />
            </div>
          ))}
        </div>
        <main className={styles["main"]}>
          <img
            className={styles["neos-logo"]}
            src={`${NeosConfig.assetsPath}/neos_logo.png`}
            alt="YGO NEOS"
          />
          <img
            className={styles["neos-pic"]}
            src={`${NeosConfig.assetsPath}/neos.png`}
            alt="neos"
          />
        </main>
        <Link to="/sso" className={styles["start-btn"]}>
          <span>登录游戏</span>
          <RightOutlined />
        </Link>
      </div>
    </>
  );
};

export default Start;
