/// <reference types="react-scripts" />
/// <reference types="vite/client" />

interface ImportMetaEnv {
  readonly VITE_IS_AI_MODE: boolean;
  readonly VITE_IS_AI_FIRST: boolean;
  readonly VITE_AI_MODE_DEFAULT_DECK: string;
}

interface ImportMeta {
  readonly env: ImportMetaEnv;
}

/**
 * 手动声明WASM模块rust-src
 */
declare module "rust-src" {
  export default function rustInit(url?: URL): Promise<void>;
  export class BufferWriter {
    constructor();
    public writeInt8(value: number): void;
    public writeUint8(value: number): void;
    public writeInt16(value: number): void;
    public writeUint16(value: number): void;
    public writeInt32(value: number): void;
    public writeUint32(value: number): void;
    public toArray(): Uint8Array;
  }
  export class BufferReader {
    constructor(buffer: Uint8Array);
    public readInt8(): number;
    public readUint8(): number;
    public readInt16(): number;
    public readUint16(): number;
    public readInt32(): number;
    public readUint32(): number;
  }
}
