// 等待房间页面的状态管理
import { proxy } from "valtio";

import { ygopro } from "@/api";
import StocHsPlayerChange = ygopro.StocHsPlayerChange;
import SelfType = ygopro.StocTypeChange.SelfType;
import { type NeosStore } from "./shared";

export interface Player {
  name: string; // 玩家的昵称
  state: StocHsPlayerChange.State; // 玩家当前状态
  deckInfo?: DeckInfo;
}

// 卡组的数量信息，在猜拳阶段由后端传入
interface DeckInfo {
  mainSize: number;
  extraSize: number;
  sideSize: number;
}

// 房间内当前的阶段
export enum RoomStage {
  WAITING = 0, // 正在准备
  MORA = 1, // 正在猜拳
  SELECT_HAND = 2, // 选择猜拳
  SELECT_TP = 2, // 选边
}

class RoomStore implements NeosStore {
  joined: boolean = false; // 是否已经加入房间
  players: Player[] = []; // 进入房间的玩家列表
  observerCount: number = 0; // 观战者数量
  isHost: boolean = false; // 当前玩家是否是房主
  selfType: SelfType = 0; // 当前玩家的类型

  stage: RoomStage = RoomStage.WAITING;

  getMePlayer() {
    if (this.selfType == SelfType.PLAYER1) return this.players[0];
    return this.players[1];
  }
  getOpPlayer() {
    if (this.selfType == SelfType.PLAYER1) return this.players[1];
    return this.players[0];
  }

  reset(): void {
    this.joined = false;
    this.players = [];
    this.observerCount = 0;
    this.isHost = false;
    this.stage = RoomStage.WAITING;
  }
}

export const roomStore = proxy<RoomStore>(new RoomStore());
