import { createBrowserRouter, RouterProvider } from "react-router-dom";

const router = createBrowserRouter([
  {
    path: "/",
    lazy: () => import("./Layout"),
    children: [
      {
        path: "/",
        lazy: () => import("./Start"),
      },
      {
        path: "/match",
        lazy: () => import("./Match"),
      },
      {
        path: "/build",
        lazy: () => import("./BuildDeck"),
      },
      {
        path: "/profile",
        lazy: () => import("./Profile"),
      },
      {
        path: "/waitroom",
        lazy: () => import("./WaitRoom"),
      },
      {
        path: "/duel/:ip/:player/:passWd",
        lazy: () => import("./Duel/Main"),
      },
    ],
  },
]);

export const NeosRouter = () => <RouterProvider router={router} />;
