import {
  CheckOutlined,
  DeleteOutlined,
  EditOutlined,
  FilterOutlined,
  PlusOutlined,
  SearchOutlined,
  SortAscendingOutlined,
  UndoOutlined,
} from "@ant-design/icons";
import {
  Button,
  ConfigProvider,
  Input,
  Layout,
  Menu,
  type MenuProps,
  Space,
  type ThemeConfig,
} from "antd";

import { Background } from "../Shared";
import styles from "./index.module.scss";

const { Content, Sider } = Layout;

type MenuItem = Required<MenuProps>["items"][number];

// 生成伪菜单栏
function getItem(
  label: React.ReactNode,
  key: React.Key,
  icon?: React.ReactNode,
  children?: MenuItem[],
  type?: "group"
): MenuItem {
  return {
    key,
    icon,
    children,
    label,
    type,
  } as MenuItem;
}
const items: MenuProps["items"] = Array.from({ length: 15 }).map((_, i) =>
  getItem(`卡组 ${i}`, i.toString())
);

const theme: ThemeConfig = {
  components: {
    Menu: {
      colorItemBg: "#ffffff00",
      colorItemBgSelected: "#ffffff33",
      colorItemTextSelected: "#ffffff",
      colorActiveBarBorderSize: 0,
      fontSize: 12,
      fontSizeLG: 12,
    },
    Layout: {
      colorBgBody: "transparent",
    },
  },
};

export const Component: React.FC = () => {
  return (
    <ConfigProvider theme={theme}>
      <Background />
      <Layout className={styles.layout} style={{ width: "100%" }}>
        <Sider width={220} className={styles.sider}>
          <Menu
            className={styles.menu}
            defaultSelectedKeys={["1"]}
            defaultOpenKeys={["sub1"]}
            items={items}
          />
          <Button
            className={styles["btn-add"]}
            icon={<PlusOutlined />}
            shape="circle"
            type="text"
          ></Button>
        </Sider>
        <Content className={styles.content}>
          <Deck />
          <Select />
        </Content>
      </Layout>
    </ConfigProvider>
  );
};
Component.displayName = "Build";

const Deck: React.FC = () => {
  return (
    <div className={styles.deck}>
      <div className={styles.container}>
        <Space
          className={styles.title}
          style={{ justifyContent: "space-between" }}
        >
          <Input
            placeholder="我的卡组"
            bordered={false}
            prefix={<EditOutlined />}
          />
          <Space style={{ marginRight: 6 }}>
            <Button type="text" size="small" icon={<DeleteOutlined />}>
              清空
            </Button>
            <Button type="text" size="small" icon={<UndoOutlined />}>
              重置
            </Button>
            <Button type="text" size="small" icon={<CheckOutlined />}>
              保存
            </Button>
          </Space>
        </Space>
        <div className={styles["deck-zone"]}>
          <div className={styles.main}>
            <div className={styles["card-continer"]}>
              {Array.from({ length: 60 }).map((_, i) => (
                <div className={styles.card} key={i} />
              ))}
            </div>
          </div>
          <div className={styles.extra}>
            <div className={styles["card-continer"]}>
              {Array.from({ length: 15 }).map((_, i) => (
                <div className={styles.card} key={i} />
              ))}
            </div>
          </div>
          <div className={styles.side}>
            <div className={styles["card-continer"]}>
              {Array.from({ length: 15 }).map((_, i) => (
                <div className={styles.card} key={i} />
              ))}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

const Select: React.FC = () => {
  return (
    <div className={styles.select}>
      <div className={styles.container}>
        <div className={styles.title}>
          <Input
            placeholder="搜索卡片"
            bordered={false}
            suffix={<Button type="text" icon={<SearchOutlined />} />}
          />
        </div>
        <div className={styles["select-btns"]}>
          <Button block type="text" icon={<FilterOutlined />}>
            筛选
          </Button>
          <Button block type="text" icon={<SortAscendingOutlined />}>
            排列
          </Button>
          <Button block type="text" icon={<DeleteOutlined />}>
            重置
          </Button>
        </div>
        <div className={styles["search-cards-container"]}>
          <div className={styles["search-cards"]}>
            {Array.from({ length: 60 }).map((_, i) => (
              <div className={styles.card} key={i} />
            ))}
          </div>
        </div>
      </div>
    </div>
  );
};
