/* eslint-disable no-await-in-loop */
import FormData from "form-data";
import fetch from "node-fetch";
import moment from "moment";
import * as Sentry from "@sentry/node";

import Room from "@game/Room";
import Recorder from "@game/Recorder";

import Client from "@network/Client";

import logger, { __DEBUG_LOG__ } from "@utils/logger";

export default class Uploader {
    public static async upload(room: Room, clients: Client[], recorder: Recorder) {
        try {
            if (!process.env.__UPLOAD_ENDPOINT__) {
                __DEBUG_LOG__("bypassed");
                return;
            }

            const formData = new FormData();
            formData.append(
                "info",
                JSON.stringify({
                    rules: { ...room.gameOptions },
                    clients: clients.map(client => client.toData()),
                    startTime: recorder.startTime.unix(),
                    endTime: moment().unix(),
                }),
            );

            clients.forEach(client => {
                formData.append("clientDecks", client.deckBuffer, {
                    contentType: "application/x-binary",
                    filename: `${client.position}.dat`,
                });
            });

            formData.append("data", recorder.recordedBuffer, {
                contentType: "application/x-binary",
                filename: "duel.dat",
            });

            const response = await fetch(process.env.__UPLOAD_ENDPOINT__, {
                method: "POST",
                headers: formData.getHeaders(),
                body: formData,
            });

            const data = await response.json();
            if (data.status !== 0) {
                throw new Error(`Failed to upload replay data to server, response code: ${data.status}`);
            }
        } catch (e) {
            if (__DEV__) {
                console.error(e);
            }

            Sentry.captureException(e);
            logger.warn("Failed to upload replay data to server.");
        }
    }
}
