// eslint-disable-next-line import/prefer-default-export
import { BaseMessageData } from "@network/message";

export enum ClientToServerMessageType {
    UNKNOWN = -1,
    RESPONSE = 1,
    UPDATE_DECK = 2,
    HAND_RESULT = 3,
    TP_RESULT = 4,
    PLAYER_INFO = 16,
    CREATE_GAME = 17,
    JOIN_GAME = 18,
    LEAVE_GAME = 19,
    SURRENDER = 20,
    TIME_CONFIRM = 21,
    CHAT = 22,
    HS_TODUELIST = 32,
    HS_TOOBSERVER = 33,
    HS_READY = 34,
    HS_NOTREADY = 35,
    HS_KICK = 36,
    HS_START = 37,
    REQUEST_FIELD = 48,
}

export interface ChatMessageData extends BaseMessageData<ClientToServerMessageType.CHAT> {
    message: string;
}
export interface TPResultMessageData extends BaseMessageData<ClientToServerMessageType.TP_RESULT> {}
export interface HandResultMessageData extends BaseMessageData<ClientToServerMessageType.HAND_RESULT> {}
export interface UpdateDeckMessageData extends BaseMessageData<ClientToServerMessageType.UPDATE_DECK> {}
export interface TimeConfirmMessageData extends BaseMessageData<ClientToServerMessageType.TIME_CONFIRM> {}
export interface PlayerInfoMessageData extends BaseMessageData<ClientToServerMessageType.PLAYER_INFO> {
    name: string;
}
export interface JoinGameMessageData extends BaseMessageData<ClientToServerMessageType.JOIN_GAME> {
    version: number;
    align: number;
    gameid: number;
    password: string;
}
export interface KickMessageData extends BaseMessageData<ClientToServerMessageType.HS_KICK> {
    position: number;
}

export type ClientToServerMessages =
    | ChatMessageData
    | TPResultMessageData
    | HandResultMessageData
    | UpdateDeckMessageData
    | TimeConfirmMessageData
    | PlayerInfoMessageData
    | JoinGameMessageData
    | KickMessageData;
