import "reflect-metadata";
import * as Sentry from "@sentry/node";
import fs from "fs-extra";
import path from "path";

import initializeAPIServer from "@root/api";
import App from "@root/App";

declare global {
    namespace NodeJS {
        interface Global {
            __SENTRY_DSN__: string;
            __DEV__: boolean;
            __VERSION__: string;
            __SENTRY_PROVIDED__: boolean;
        }
    }
}

global.__SENTRY_PROVIDED__ = typeof __SENTRY_PROVIDED__ === "undefined" ? false : __SENTRY_PROVIDED__;
global.__SENTRY_DSN__ = typeof __SENTRY_DSN__ === "undefined" ? process.env.__SENTRY_DSN__! : __SENTRY_DSN__;
global.__DEV__ = typeof __DEV__ === "undefined" ? true : __DEV__;
global.__VERSION__ = typeof __VERSION__ === "undefined" ? "dev" : __VERSION__;

if (process.env.__PRERELEASE__ !== "1") {
    fs.removeSync(path.join("./ygopro", "expansions"));
}

if (global.__SENTRY_PROVIDED__) {
    Sentry.init({
        dsn: global.__SENTRY_DSN__,
    });
}

initializeAPIServer().then(() => {
    new App().start(3000);
});
