/* eslint-disable @typescript-eslint/no-unused-vars,class-methods-use-this */
import { Arg, Int, Mutation, Query, Resolver } from "type-graphql";

import RoomObject from "@root/api/Room";
import Room from "@game/Room";

@Resolver(of => RoomObject)
export default class RoomResolver {
    @Query(returns => Int)
    public async roomCount() {
        return Room.getOpenedRoomCount();
    }

    @Query(returns => [RoomObject])
    public async rooms() {
        return Room.dumpAllRooms();
    }

    @Mutation(returns => Boolean)
    public async destroyRoom(@Arg("id") id: string) {
        const room = Room.findRoomById(id);
        if (!room) return false;

        room.destroy();
        return true;
    }
}
