/* eslint-disable @typescript-eslint/no-unused-vars,class-methods-use-this */
import { Arg, Int, Mutation, Query, Resolver } from "type-graphql";

import Client from "@network/Client";

import ClientObject from "@api/Client";

@Resolver(of => ClientObject)
export default class ClientResolver {
    @Query(returns => [ClientObject])
    public clients() {
        return Client.dumpAllClients();
    }

    @Query(returns => Int)
    public clientCount() {
        return Client.dumpAllClients().length;
    }

    @Mutation(returns => Int)
    public broadcastMessage(@Arg("message") message: string) {
        return Client.broadcastMessage(message);
    }
}
