import net from "net";

import Client from "@network/Client";

import logger from "@utils/logger";

export default class App {
    private server: net.Server;

    public constructor() {
        this.server = net.createServer(this.onConnect);
    }

    public start(port: number) {
        this.server.listen(port, () => {
            logger.info(`The server is now listening on port: ${port}`);
        });
    }

    private onConnect = (clientSocket: net.Socket) => {
        logger.info(`Client connected from: ${clientSocket.remoteAddress}`);

        // eslint-disable-next-line no-new
        new Client(clientSocket);
    };
}
