import winston from "winston";
import chalk from "chalk";

const logger = winston.createLogger({
    format: winston.format.combine(
        winston.format.timestamp({
            format: "HH:mm:ss.SSS",
        }),
        winston.format.printf(({ timestamp, message, level }) => {
            let chalkFunction = chalk.blue;
            if (level === "warn") {
                chalkFunction = chalk.yellow;
            } else if (level === "error") {
                chalkFunction = chalk.red;
            } else if (level === "debug") {
                chalkFunction = chalk.cyan;
            }

            let levelText = level;
            if (level === "error") {
                levelText = "errr";
            } else if (level === "debug") {
                levelText = "debg";
            }

            levelText = levelText
                .padEnd(4, " ")
                .slice(0, 4)
                .toUpperCase();

            return `${chalk.green(`[${timestamp}]`)}${chalkFunction(`[${levelText}]`)} ${message}`;
        }),
    ),

    transports: [new winston.transports.Console({ level: "debug" })],
});

// eslint-disable-next-line no-underscore-dangle
export function __DEBUG_LOG__(content: string) {
    if (__DEV__) {
        logger.debug(content);
    }
}

export default logger;
