import { BaseMessageData, PacketType } from "@network/message";
import { ServerToClientMessages } from "@network/message/stoc";
import { ClientToServerMessages } from "@network/message/ctos";

export enum GameType {
    Single = "0",
    Match = "1",
    Tag = "2",
}

export interface GameOption {
    type: GameType;
    lifePoints: number;
    timeLimit: number;
    startHandCount: number;
    drawCount: number;
    lfList: number;
    rule: number;
    noDeckCheck: boolean;
    noDeckShuffle: boolean;
    duelRule: number | string;
    autoDeath: number;
    isAIRoom: boolean;
}

export type ObjectType<Values> = {
    [key: string]: Values;
};

export type UnionToIntersection<U> = (U extends any ? (k: U) => void : never) extends (k: infer I) => void ? I : never;

export type PacketData<PT extends PacketType.ServerToClient | PacketType.ClientToServer> =
    | BaseMessageData<string>
    | (PT extends PacketType.ServerToClient ? ServerToClientMessages : ClientToServerMessages);

export type OmitFirstArg<F> = F extends (x: any, ...args: infer P) => infer R ? P : never;
