// eslint-disable-next-line import/prefer-default-export
import { BaseMessageData } from "@network/message";

export enum ServerToClientMessageType {
    UNKNOWN = -1,
    GAME_MSG = 1,
    ERROR_MSG = 2,
    SELECT_HAND = 3,
    SELECT_TP = 4,
    HAND_RESULT = 5,
    TP_RESULT = 6,
    CHANGE_SIDE = 7,
    WAITING_SIDE = 8,
    CREATE_GAME = 17,
    JOIN_GAME = 18,
    TYPE_CHANGE = 19,
    LEAVE_GAME = 20,
    DUEL_START = 21,
    DUEL_END = 22,
    REPLAY = 23,
    TIME_LIMIT = 24,
    CHAT = 25,
    HS_PLAYER_ENTER = 32,
    HS_PLAYER_CHANGE = 33,
    HS_WATCH_CHANGE = 34,
    FIELD_FINISH = 48,
}

export interface PlayerChangeMessageData extends BaseMessageData<ServerToClientMessageType.HS_PLAYER_CHANGE> {
    status: number;
}
export interface ChangeSideMessageData extends BaseMessageData<ServerToClientMessageType.CHANGE_SIDE> {}
export interface SelectTPMessageData extends BaseMessageData<ServerToClientMessageType.SELECT_TP> {}
export interface SelectHandMessageData extends BaseMessageData<ServerToClientMessageType.SELECT_HAND> {}
export interface DuelStartMessageData extends BaseMessageData<ServerToClientMessageType.DUEL_START> {}
export interface JoinGameMessageData extends BaseMessageData<ServerToClientMessageType.JOIN_GAME> {}
export interface TimeLimitMessageData extends BaseMessageData<ServerToClientMessageType.TIME_LIMIT> {
    player: number;
    timeLeft: number;
}
export interface GameMessageData extends BaseMessageData<ServerToClientMessageType.GAME_MSG> {}
export interface TypeChangeMessageData extends BaseMessageData<ServerToClientMessageType.TYPE_CHANGE> {
    value: number;
}

export type ServerToClientMessages =
    | PlayerChangeMessageData
    | ChangeSideMessageData
    | SelectTPMessageData
    | SelectHandMessageData
    | DuelStartMessageData
    | JoinGameMessageData
    | TimeLimitMessageData
    | GameMessageData
    | TypeChangeMessageData;
