import { ApolloServer, ServerInfo } from "apollo-server";
import { buildSchema, registerEnumType } from "type-graphql";

import { RoomType } from "@game/Room";

import RoomResolver from "@api/Room.resolver";
import ClientResolver from "@api/Client.resolver";

import logger from "@utils/logger";

import { RoomState } from "@root/constants";

registerEnumType(RoomType, {
    name: "RoomType",
});

registerEnumType(RoomState, {
    name: "RoomState",
});

export default async function initializeAPIServer() {
    const schema = await buildSchema({
        resolvers: [RoomResolver, ClientResolver],
    });

    // The ApolloServer constructor requires two parameters: your schema
    // definition and your set of resolvers.
    const server = new ApolloServer({
        schema,
        introspection: __DEV__,
        debug: __DEV__,
        playground: __DEV__,
    });

    await new Promise(resolve => {
        // The `listen` method launches a web server.
        server.listen().then(({ port }: ServerInfo) => {
            logger.info(`Apollo graphql api server is now opened on port: ${port}`);
            resolve();
        });
    });
}
