-- Maximum
TYPE_MAXIMUM = 0x400
SUMMON_TYPE_MAXIMUM = 0x45000000
RushDuel = RushDuel or {}
RD = RushDuel

function RushDuel.AddMaximumProcedure(c, max_atk, left_code, right_code)
    -- Maximum Summon
    local e1 = Effect.CreateEffect(c)
    e1:SetDescription(aux.Stringid(120000000, 0))
    e1:SetType(EFFECT_TYPE_FIELD)
    e1:SetCode(EFFECT_SPSUMMON_PROC_G)
    e1:SetProperty(EFFECT_FLAG_CANNOT_DISABLE + EFFECT_FLAG_UNCOPYABLE)
    e1:SetRange(LOCATION_HAND)
    e1:SetCondition(function(e, c, og)
        if c == nil then
            return true
        end
        local tp = c:GetControler()
        local mg = Duel.GetMatchingGroup(RushDuel.MaximumSummonFilter, tp, LOCATION_HAND, 0, nil, e, tp, left_code, right_code)
        local fg = Duel.GetFieldGroup(tp, LOCATION_MZONE, 0)
        return Duel.GetMZoneCount(tp, fg) > 0 and not Duel.IsPlayerAffectedByEffect(tp, 59822133) and mg:CheckSubGroup(RushDuel.MaximumSummonCheck, 2, 2)
    end)
    e1:SetOperation(function(e, tp, eg, ep, ev, re, r, rp, c, sg, og)
        local mg = Duel.GetMatchingGroup(RushDuel.MaximumSummonFilter, tp, LOCATION_HAND, 0, nil, e, tp, left_code, right_code)
        Duel.Hint(HINT_SELECTMSG, tp, aux.Stringid(120000000, 1))
        local cancel = Duel.GetCurrentChain() == 0
        local g = mg:SelectSubGroup(tp, RushDuel.MaximumSummonCheck, cancel, 2, 2)
        if not g then
            return
        end
        local fg = Duel.GetFieldGroup(tp, LOCATION_MZONE, 0)
        Duel.SendtoGrave(fg, REASON_RULE)
        c:SetMaterial(g)
        sg:AddCard(c)
        sg:Merge(g)
    end)
    e1:SetValue(SUMMON_TYPE_MAXIMUM)
    c:RegisterEffect(e1)
    -- Maximum Material
    local e2 = Effect.CreateEffect(c)
    e2:SetType(EFFECT_TYPE_SINGLE + EFFECT_TYPE_CONTINUOUS)
    e2:SetCode(EVENT_SPSUMMON_SUCCESS)
    e2:SetProperty(EFFECT_FLAG_CANNOT_DISABLE + EFFECT_FLAG_UNCOPYABLE)
    e2:SetCondition(RushDuel.MaximumMode)
    e2:SetOperation(RushDuel.MaximumOverlay)
    c:RegisterEffect(e2)
    -- Maximun Atk
    local e3 = Effect.CreateEffect(c)
    e3:SetType(EFFECT_TYPE_SINGLE)
    e3:SetCode(EFFECT_SET_BASE_ATTACK)
    e3:SetProperty(EFFECT_FLAG_SINGLE_RANGE + EFFECT_FLAG_CANNOT_DISABLE + EFFECT_FLAG_UNCOPYABLE)
    e3:SetRange(LOCATION_MZONE)
    e3:SetCondition(RushDuel.MaximumMode)
    e3:SetValue(max_atk)
    c:RegisterEffect(e3)
    -- Position
    local e4 = Effect.CreateEffect(c)
    e4:SetType(EFFECT_TYPE_SINGLE)
    e4:SetCode(EFFECT_SET_POSITION)
    e4:SetProperty(EFFECT_FLAG_SINGLE_RANGE + EFFECT_FLAG_CANNOT_DISABLE + EFFECT_FLAG_UNCOPYABLE)
    e4:SetRange(LOCATION_MZONE)
    e4:SetValue(POS_FACEUP_ATTACK)
    e4:SetCondition(RushDuel.MaximumMode)
    c:RegisterEffect(e4)
    local e5 = Effect.CreateEffect(c)
    e5:SetType(EFFECT_TYPE_SINGLE)
    e5:SetCode(EFFECT_CANNOT_CHANGE_POSITION)
    e5:SetProperty(EFFECT_FLAG_SINGLE_RANGE + EFFECT_FLAG_CANNOT_DISABLE + EFFECT_FLAG_UNCOPYABLE)
    e5:SetRange(LOCATION_MZONE)
    e5:SetCondition(RushDuel.MaximumMode)
    c:RegisterEffect(e5)
    local e6 = e5:Clone()
    e6:SetCode(EFFECT_CANNOT_CHANGE_POS_E)
    e6:SetCondition(RushDuel.MaximumPositionCondition)
    c:RegisterEffect(e6)
    local e7 = Effect.CreateEffect(c)
    e7:SetType(EFFECT_TYPE_SINGLE)
    e7:SetCode(EFFECT_CANNOT_TURN_SET)
    e7:SetProperty(EFFECT_FLAG_SINGLE_RANGE + EFFECT_FLAG_CANNOT_DISABLE + EFFECT_FLAG_UNCOPYABLE)
    e7:SetRange(LOCATION_MZONE)
    e7:SetCondition(RushDuel.MaximumMode)
    c:RegisterEffect(e7)
    -- Use 3 MZone
    local e8 = Effect.CreateEffect(c)
    e8:SetType(EFFECT_TYPE_FIELD)
    e8:SetCode(EFFECT_MAX_MZONE)
    e8:SetProperty(EFFECT_FLAG_PLAYER_TARGET + EFFECT_FLAG_CANNOT_DISABLE + EFFECT_FLAG_UNCOPYABLE)
    e8:SetRange(LOCATION_MZONE)
    e8:SetTargetRange(1, 0)
    e8:SetCondition(RushDuel.MaximumMode)
    e8:SetValue(1)
    c:RegisterEffect(e8)
    -- Leave Field
    local e9 = Effect.CreateEffect(c)
    e9:SetType(EFFECT_TYPE_SINGLE + EFFECT_TYPE_CONTINUOUS)
    e9:SetCode(EVENT_LEAVE_FIELD_P)
    e9:SetProperty(EFFECT_FLAG_CANNOT_DISABLE + EFFECT_FLAG_UNCOPYABLE)
    e9:SetCondition(RushDuel.MaximumMode)
    e9:SetOperation(RushDuel.MaximumLeaveOperation)
    c:RegisterEffect(e9)
end
function RushDuel.MaximumSummonFilter(c, e, tp, left_code, right_code)
    return c:IsCode(left_code, right_code) and c:IsCanBeSpecialSummoned(e, 0, tp, false, false, POS_FACEUP)
end
function RushDuel.MaximumSummonCheck(g)
    return g:GetClassCount(Card.GetCode) == g:GetCount()
end
function RushDuel.MaximumMode(e)
    return e:GetHandler():IsSummonType(SUMMON_TYPE_MAXIMUM)
end
function RushDuel.MaximumOverlay(e, tp, eg, ep, ev, re, r, rp)
    local c = e:GetHandler()
    local mg = c:GetMaterial()
    Duel.Overlay(c, mg)
    Duel.MoveSequence(c, 2)
end
function RushDuel.MaximumPositionCondition(e)
    return RushDuel.MaximumMode(e) and e:GetHandler():IsAttackPos()
end
function RushDuel.MaximumLeaveOperation(e, tp, eg, ep, ev, re, r, rp)
    local c = e:GetHandler()
    local loc = c:GetDestination()
    local g = c:GetOverlayGroup()
    if loc == LOCATION_HAND then
        Duel.SendtoHand(g, nil, REASON_RULE)
    elseif loc == LOCATION_DECK then
        Duel.SendtoDeck(g, nil, 2, REASON_RULE)
    elseif loc == LOCATION_REMOVED then
        Duel.Remove(g, POS_FACEUP, REASON_RULE)
    end
end

-- Expand

-- Is Monster has Def (Maximum)
function RushDuel.IsHasDefense(c)
    return c:IsDefenseAbove(0) and not (c:IsSummonType(SUMMON_TYPE_MAXIMUM) and c:GetOverlayCount() > 0)
end
