import os
import requests

# 读取环境变量
USERNAME = os.environ.get("SRVPRO_USERNAME", "").strip()
PASSWORD = os.environ.get("SRVPRO_PASSWORD", "").strip()

# 读取 version.txt 内容
def get_version_content():
    try:
        with open("dist/version.txt", "r", encoding="utf-8") as file:
            return file.read().strip()
    except FileNotFoundError:
        print("Error: version.txt not found!")
        exit(1)

# 构造请求参数
def send_request():
    url = "https://diyfree.momobako.com:11922/api/message"
    params = {
        "welcome": get_version_content(),
        "username": USERNAME,
        "pass": PASSWORD
    }

    try:
        response = requests.get(url, params=params, timeout=10)  # 10 秒超时
        response.raise_for_status()  # 如果状态码不是 200-299，则抛出异常
        print("Response Status:", response.status_code)
        print("Response Body:", response.text)
    except requests.exceptions.RequestException as e:
        print(f"Request failed: {e}")
        exit(1)

if __name__ == "__main__":
    send_request()
