--Extra Data of DJ.Tenka
Tenka=Tenka or {}
--Mogami Shizuka, 81018xxx, 0x81b
function Tenka.Shizuka(c)
	local ea=Effect.CreateEffect(c)
	ea:SetType(EFFECT_TYPE_SINGLE)
	ea:SetCode(EFFECT_REFLECT_BATTLE_DAMAGE)
	ea:SetValue(1)
	c:RegisterEffect(ea)
	local eb=Effect.CreateEffect(c)
	eb:SetType(EFFECT_TYPE_SINGLE)
	eb:SetProperty(EFFECT_FLAG_SINGLE_RANGE)
	eb:SetRange(LOCATION_MZONE)
	eb:SetCode(EFFECT_INDESTRUCTABLE_COUNT)
	eb:SetCountLimit(1)
	eb:SetValue(Tenka.ShizukaValcon)
	c:RegisterEffect(eb)
end
function Tenka.ShizukaValcon(e,re,r,rp)
	return bit.band(r,REASON_BATTLE)~=0
end
--Reika effect condition
function Tenka.ReikaCon(e,tp,eg,ep,ev,re,r,rp)
	local tp=e:GetHandlerPlayer()
	for i=0,4 do
		if Duel.GetFieldCard(tp,LOCATION_SZONE,i) then return false end
	end
	return true
end
--koikake atk
function Tenka.KoikakeRitual(c)
	local ea=Effect.CreateEffect(c)
	ea:SetType(EFFECT_TYPE_SINGLE)
	ea:SetProperty(EFFECT_FLAG_SINGLE_RANGE)
	ea:SetRange(LOCATION_MZONE)
	ea:SetCode(EFFECT_UPDATE_ATTACK)
	ea:SetCondition(Tenka.KoikakeAtkcon)
	ea:SetValue(Tenka.KoikakeAtkval)
	c:RegisterEffect(ea)
end
function Tenka.KoikakeLink(c)
	local ea=Effect.CreateEffect(c)
	ea:SetType(EFFECT_TYPE_SINGLE)
	ea:SetCode(EFFECT_UPDATE_ATTACK)
	ea:SetProperty(EFFECT_FLAG_SINGLE_RANGE)
	ea:SetRange(LOCATION_MZONE)
	ea:SetCondition(Tenka.KoikakeAtkcon)
	ea:SetValue(Tenka.KoikakeLinkAtkval)
	c:RegisterEffect(ea)
end
function Tenka.KoikakeAtkcon(e)
	local ph=Duel.GetCurrentPhase()
	return ph>=PHASE_BATTLE_START and ph<=PHASE_BATTLE
end
function Tenka.KoikakeAtkFilter(c)
	return c:IsFaceup() and c:IsType(TYPE_RITUAL) and c:IsType(TYPE_PENDULUM) and c:GetLevel()>0
end
function Tenka.KoikakeLinkAtkval(e,c)
	local lg=c:GetLinkedGroup():Filter(Tenka.KoikakeAtkFilter,nil)
	return lg:GetSum(Card.GetLevel)*300
end
function Tenka.KoikakeAtkval(e,c)
	return c:GetLevel()*300
end
--Witch of the Lamplight
function Tenka.Asamiya(c)
	c:EnableReviveLimit()
	aux.AddCodeList(c,81027000)
	aux.EnableChangeCode(c,81027000,LOCATION_MZONE+LOCATION_HAND)
end
--Einstein
function Tenka.Einstein(c)
	local ea=Effect.CreateEffect(c)
	ea:SetType(EFFECT_TYPE_FIELD)
	ea:SetCode(EFFECT_REFLECT_BATTLE_DAMAGE)
	ea:SetRange(LOCATION_MZONE)
	ea:SetProperty(EFFECT_FLAG_PLAYER_TARGET)
	ea:SetTargetRange(0,1)
	ea:SetCondition(Tenka.EinsteinRfcon)
	c:RegisterEffect(ea)
	if not Tenka.global_check then
		Tenka.global_check=true
		local gea=Effect.CreateEffect(c)
		gea:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_CONTINUOUS)
		gea:SetCode(EVENT_DAMAGE)
		gea:SetOperation(Tenka.EinsteinCheckOp)
		Duel.RegisterEffect(gea,0)
	end
end
function Tenka.EinsteinRfcon(e)
	return Duel.GetAttacker()==e:GetHandler() or Duel.GetAttackTarget()==e:GetHandler()
end
function Tenka.EinsteinCheckOp(e,tp,eg,ep,ev,re,r,rp)
	if bit.band(r,REASON_BATTLE)~=0 then
		Duel.RegisterFlagEffect(ep,81024000,RESET_PHASE+PHASE_END,0,1)
	end
end
function Tenka.EinMainCon(e,tp,eg,ep,ev,re,r,rp)
	return Duel.GetFlagEffect(tp,81024000)~=0 and (Duel.GetCurrentPhase()==PHASE_MAIN1 or Duel.GetCurrentPhase()==PHASE_MAIN2)
end
function Tenka.EinBattleCon(e,tp,eg,ep,ev,re,r,rp)
	local c=e:GetHandler()
	return ep==tp and c:IsRelateToBattle()
end
--Miyako
function Tenka.MiyakoCost(e,tp,eg,ep,ev,re,r,rp,chk)
	if chk==0 then return Duel.IsExistingMatchingCard(Tenka.MiyakoCostFilter,tp,LOCATION_MZONE+LOCATION_HAND,0,1,nil,tp) end
	Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_TOGRAVE)
	local g=Duel.SelectMatchingCard(tp,Tenka.MiyakoCostFilter,tp,LOCATION_MZONE+LOCATION_HAND,0,1,1,nil,tp)
	Duel.SendtoGrave(g,REASON_COST)
end
function Tenka.MiyakoCostFilter(c,tp)
	return ((c:IsFaceup() and bit.band(c:GetOriginalType(),TYPE_TRAP)~=0 and bit.band(c:GetOriginalType(),TYPE_CONTINUOUS)~=0 and c:IsType(TYPE_MONSTER)) or c:IsHasEffect(81049012,tp)) and c:IsAbleToGraveAsCost() and (c:IsLocation(LOCATION_HAND) or c:IsFaceup())
end
--Chiyuu
function Tenka.Chiyuu(c,m)
	c:SetSPSummonOnce(m)
	aux.AddXyzProcedure(c,aux.FilterBoolFunction(Card.IsSetCard,0x581f),4,2,Tenka.ChiyuuFilter,aux.Stringid(81066000,0))
	c:EnableReviveLimit()
end
function Tenka.ChiyuuFilter(c)
	return c:IsFaceup() and c:IsType(TYPE_LINK) and c:IsSetCard(0x581f)
end
--Arisa
function Tenka.ArisugawaArisa(c)
	local ea=Effect.CreateEffect(c)
	ea:SetType(EFFECT_TYPE_SINGLE)
	ea:SetCode(EFFECT_IMMUNE_EFFECT)
	ea:SetProperty(EFFECT_FLAG_SINGLE_RANGE)
	ea:SetRange(LOCATION_MZONE)
	ea:SetCondition(Tenka.Arisugawaiscon)
	ea:SetValue(Tenka.ArisugawaesFilter)
	c:RegisterEffect(ea)
	local eb=Effect.CreateEffect(c)
	eb:SetDescription(aux.Stringid(60060000,0))
	eb:SetType(EFFECT_TYPE_IGNITION)
	eb:SetProperty(EFFECT_FLAG_CARD_TARGET)
	eb:SetRange(LOCATION_MZONE)
	eb:SetCountLimit(1)
	eb:SetTarget(Tenka.Arisugawamvtg)
	eb:SetOperation(Tenka.Arisugawamvop)
	c:RegisterEffect(eb)
end
function Tenka.Arisugawaiscon(e)
	local seq=e:GetHandler():GetSequence()
	return seq==0 or seq==4
end
function Tenka.ArisugawaesFilter(e,te)
	return te:GetOwnerPlayer()~=e:GetHandlerPlayer()
end
function Tenka.Arisugawamvtg(e,tp,eg,ep,ev,re,r,rp,chk,chkc)
	if chkc then return chkc:IsLocation(LOCATION_MZONE) and chkc:IsControler(tp) end
	if chk==0 then return Duel.IsExistingTarget(nil,tp,LOCATION_MZONE,0,1,nil)
		and Duel.GetLocationCount(tp,LOCATION_MZONE,PLAYER_NONE,0)>0 end
	Duel.Hint(HINT_SELECTMSG,tp,aux.Stringid(60060000,2))
	Duel.SelectTarget(tp,nil,tp,LOCATION_MZONE,0,1,1,nil)
end
function Tenka.Arisugawamvop(e,tp,eg,ep,ev,re,r,rp)
	local tc=Duel.GetFirstTarget()
	if not tc:IsRelateToEffect(e) or tc:IsControler(1-tp)
		or Duel.GetLocationCount(tp,LOCATION_MZONE,PLAYER_NONE,0)<=0 then return end
	Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_TOZONE)
	local s=Duel.SelectDisableField(tp,1,LOCATION_MZONE,0,0)
	local nseq=math.log(s,2)
	Duel.MoveSequence(tc,nseq)
end
function Tenka.ArisugawaArisaB(c)
	local ea=Effect.CreateEffect(c)
	ea:SetType(EFFECT_TYPE_SINGLE)
	ea:SetCode(EFFECT_IMMUNE_EFFECT)
	ea:SetProperty(EFFECT_FLAG_SINGLE_RANGE)
	ea:SetRange(LOCATION_MZONE)
	ea:SetCondition(Tenka.Arisugawaiscon)
	ea:SetValue(Tenka.ArisugawaesFilter)
	c:RegisterEffect(ea)
	local eb=Effect.CreateEffect(c)
	eb:SetDescription(aux.Stringid(60060000,0))
	eb:SetType(EFFECT_TYPE_QUICK_O)
	eb:SetCode(EVENT_FREE_CHAIN)
	eb:SetProperty(EFFECT_FLAG_CARD_TARGET)
	eb:SetRange(LOCATION_MZONE)
	eb:SetCountLimit(1)
	eb:SetTarget(Tenka.Arisugawamvtg)
	eb:SetOperation(Tenka.Arisugawamvop)
	c:RegisterEffect(eb)
end
--Kanon
function Tenka.KanonAttack(c)
	local ea=Effect.CreateEffect(c)
	ea:SetDescription(aux.Stringid(20123001,1))
	ea:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_TRIGGER_O)
	ea:SetCode(EVENT_BATTLE_START)
	ea:SetTarget(Tenka.KanonChainAttackTg)
	ea:SetRange(LOCATION_MZONE)
	ea:SetCategory(CATEGORY_ATKCHANGE)
	ea:SetOperation(Tenka.KanonChainAttackOp)
	ea:SetCountLimit(1)
	c:RegisterEffect(ea)
end
function Tenka.KanonChainAttackTg(e,tp,eg,ep,ev,re,r,rp,chk)
	local c=e:GetHandler()
	local ac=Duel.GetAttacker()
	if chk==0 then return ac:IsControler(tp) and ac:IsRace(RACE_WARRIOR) and ac~=c 
		and c:GetAttackAnnouncedCount()==0 and c:IsAttackable() end
	Duel.SetTargetCard(c)
end
function Tenka.KanonChainAttackOp(e,tp,eg,ep,ev,re,r,rp)
	local c=e:GetHandler()
	local ac=Duel.GetAttacker()
	local atk=c:GetAttack()
	if atk<1 then return end
	if ac:IsFaceup() and ac:IsRelateToBattle() and c:IsRelateToEffect(e) then
		local e1=Effect.CreateEffect(c)
		e1:SetType(EFFECT_TYPE_SINGLE)
		e1:SetCode(EFFECT_CANNOT_ATTACK)
		e1:SetProperty(EFFECT_FLAG_CANNOT_DISABLE)
		e1:SetReset(RESET_EVENT+RESETS_STANDARD+RESET_PHASE+PHASE_END)
		c:RegisterEffect(e1) 
		local e2=Effect.CreateEffect(c)
		e2:SetType(EFFECT_TYPE_SINGLE)
		e2:SetProperty(EFFECT_FLAG_SINGLE_RANGE)
		e2:SetCode(EFFECT_UPDATE_ATTACK)
		e2:SetRange(LOCATION_MZONE)
		e2:SetCondition(Tenka.KanonChainAttackCon)
		e2:SetValue(atk)
		e2:SetReset(RESET_EVENT+RESETS_STANDARD+RESET_PHASE+PHASE_DAMAGE)
		ac:RegisterEffect(e2)
	end
end
function Tenka.KanonChainAttackCon(e,tp,eg,ep,ev,re,r,rp)
	local c=e:GetHandler()
	local ph=Duel.GetCurrentPhase()
	return (ph==PHASE_DAMAGE or ph==PHASE_DAMAGE_CAL) and c:IsRelateToBattle()  
end
--shiki
function Tenka.Shiki(c)
	local ea=Effect.CreateEffect(c)
	ea:SetType(EFFECT_TYPE_FIELD)
	ea:SetCode(EFFECT_REVERSE_DAMAGE)
	ea:SetRange(LOCATION_MZONE)
	ea:SetProperty(EFFECT_FLAG_PLAYER_TARGET)
	ea:SetTargetRange(1,1)
	ea:SetValue(Tenka.ShikiRev)
	c:RegisterEffect(ea)
end
function Tenka.ShikiRev(e,re,r,rp,rc)
	local c=e:GetHandler()
	return bit.band(r,REASON_BATTLE)~=0
		and (c==Duel.GetAttacker() or c==Duel.GetAttackTarget())
end
--aiko
function Tenka.ArisugawaAiko(c)
	local ea=Effect.CreateEffect(c)
	ea:SetCategory(CATEGORY_DECKDES)
	ea:SetType(EFFECT_TYPE_SINGLE+EFFECT_TYPE_TRIGGER_F)
	ea:SetCode(EVENT_BATTLE_DAMAGE)
	ea:SetCondition(Tenka.AikoDisCon)
	ea:SetTarget(Tenka.AikoDisTg)
	ea:SetOperation(Tenka.AikoDisOp)
	c:RegisterEffect(ea)
end
function Tenka.AikoDisCon(e,tp,eg,ep,ev,re,r,rp)
	return ep~=tp
end
function Tenka.AikoDisFilter(c)
	return c:IsFaceup() and c:IsRace(RACE_BEASTWARRIOR)
end
function Tenka.AikoDisTg(e,tp,eg,ep,ev,re,r,rp,chk)
	if chk==0 then return true end
	local ct=Duel.GetMatchingGroupCount(Tenka.AikoDisFilter,tp,LOCATION_MZONE,0,nil)
	Duel.SetOperationInfo(0,CATEGORY_DECKDES,0,0,1-tp,ct)
end
function Tenka.AikoDisOp(e,tp,eg,ep,ev,re,r,rp)
	local ct=Duel.GetMatchingGroupCount(Tenka.AikoDisFilter,tp,LOCATION_MZONE,0,nil)
	Duel.DiscardDeck(1-tp,ct,REASON_EFFECT)
end
--Empty Pigeon
function Tenka.EmptyPigeon(e,tp,eg,ep,ev,re,r,rp)
	return e:GetHandler():IsSummonType(SUMMON_TYPE_RITUAL) or e:GetHandler():IsSummonType(SUMMON_TYPE_PENDULUM)
end
--YunaHeath
function Tenka.YunaHeath(c)
	local ea=Effect.CreateEffect(c)
	ea:SetType(EFFECT_TYPE_SINGLE)
	ea:SetCode(EFFECT_CANNOT_BE_SYNCHRO_MATERIAL)
	ea:SetProperty(EFFECT_FLAG_SINGLE_RANGE)
	ea:SetRange(LOCATION_MZONE)
	ea:SetValue(aux.TRUE)
	c:RegisterEffect(ea)
end
--Miu
function Tenka.MiuCost(e,tp,eg,ep,ev,re,r,rp,chk)
	if chk==0 then return Duel.IsExistingMatchingCard(Tenka.MiuCostFilter,tp,LOCATION_GRAVE,0,1,nil)
		or Duel.IsPlayerAffectedByEffect(tp,1090006) end
	if Duel.IsExistingMatchingCard(Tenka.MiuCostFilter,tp,LOCATION_GRAVE,0,1,nil)
		and (not Duel.IsPlayerAffectedByEffect(tp,1090006) or not Duel.SelectYesNo(tp,aux.Stringid(1090006,0))) then
		Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_TODECK)
		local g=Duel.SelectMatchingCard(tp,Tenka.MiuCostFilter,tp,LOCATION_GRAVE,0,1,1,nil)
		Duel.SendtoDeck(g,nil,SEQ_DECKSHUFFLE,REASON_COST)
	end
end
function Tenka.MiuCostFilter(c)
	return c:IsCode(1090000) and c:IsAbleToDeckOrExtraAsCost()
end
--Nagiko
function Tenka.Nagiko(c)
	--fusion material
	c:EnableReviveLimit()
	aux.AddFusionProcFun2(c,aux.FilterBoolFunction(Card.IsRace,RACE_PSYCHO),aux.FilterBoolFunction(Card.IsFusionAttribute,ATTRIBUTE_WATER),true)
	local ea=Effect.CreateEffect(c)
	ea:SetType(EFFECT_TYPE_SINGLE)
	ea:SetProperty(EFFECT_FLAG_CANNOT_DISABLE+EFFECT_FLAG_UNCOPYABLE)
	ea:SetCode(EFFECT_SPSUMMON_CONDITION)
	ea:SetValue(Tenka.NagikoSplimit)
	c:RegisterEffect(ea)
	local eb=Effect.CreateEffect(c)
	eb:SetType(EFFECT_TYPE_FIELD)
	eb:SetProperty(EFFECT_FLAG_CANNOT_DISABLE+EFFECT_FLAG_UNCOPYABLE)
	eb:SetCode(EFFECT_SPSUMMON_PROC)
	eb:SetRange(LOCATION_EXTRA)
	eb:SetCondition(Tenka.NagikoSpcon)
	eb:SetTarget(Tenka.NagikoSptg)
	eb:SetOperation(Tenka.NagikoSpop)
	c:RegisterEffect(eb)
end
function Tenka.NagikoSplimit(e,se,sp,st)
	return not e:GetHandler():IsLocation(LOCATION_EXTRA) or aux.fuslimit(e,se,sp,st)
end
function Tenka.NagikoSpFilter(c,tp,sc)
	return c:IsAttribute(ATTRIBUTE_WATER) and c:IsRace(RACE_PSYCHO) and c:IsControler(tp) and Duel.GetLocationCountFromEx(tp,tp,c,sc)>0
		and c:IsCanBeFusionMaterial(sc,SUMMON_TYPE_SPECIAL)
end
function Tenka.NagikoSpcon(e,c)
	if c==nil then return true end
	return Duel.CheckReleaseGroupEx(c:GetControler(),Tenka.NagikoSpFilter,2,REASON_SPSUMMON,false,nil,c:GetControler(),c)
		and Duel.CheckLPCost(c:GetControler(),1000)
end
function Tenka.NagikoSptg(e,tp,eg,ep,ev,re,r,rp,chk,c)
	local rg=Duel.GetReleaseGroup(tp,false,REASON_SPSUMMON):Filter(Tenka.NagikoSpFilter,nil,tp,c)
	Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_RELEASE)
	local sg=rg:SelectSubGroup(tp,aux.mzctcheckrel,true,2,2,tp,REASON_SPSUMMON)
	if sg then
		sg:KeepAlive()
		e:SetLabelObject(sg)
		return true
	else return false end
end
function Tenka.NagikoSpop(e,tp,eg,ep,ev,re,r,rp,c)
	local tc=e:GetLabelObject()
	c:SetMaterial(Group.FromCards(tc))
	Duel.Release(tc,REASON_SPSUMMON)
	Duel.PayLPCost(tp,1000)
end
--SugarRush
function Tenka.SugarRush(c,m)
	--equip
	local ea=Effect.CreateEffect(c)
	ea:SetDescription(aux.Stringid(m,0))
	ea:SetProperty(EFFECT_FLAG_CARD_TARGET)
	ea:SetCategory(CATEGORY_EQUIP)
	ea:SetType(EFFECT_TYPE_IGNITION)
	ea:SetRange(LOCATION_MZONE)
	ea:SetTarget(Tenka.SugarEqtg)
	ea:SetOperation(Tenka.SugarEqop)
	c:RegisterEffect(ea)
	--unequip
	local eb=Effect.CreateEffect(c)
	eb:SetDescription(aux.Stringid(m,1))
	eb:SetCategory(CATEGORY_SPECIAL_SUMMON)
	eb:SetType(EFFECT_TYPE_IGNITION)
	eb:SetRange(LOCATION_SZONE)
	eb:SetTarget(Tenka.SugarSptg)
	eb:SetOperation(Tenka.SugarSpop)
	c:RegisterEffect(eb)
end
function Tenka.SugarEqFilter(c)
	return c:IsFaceup() and c:IsAttack(1550) and c:IsDefense(1050)
end
function Tenka.SugarEqtg(e,tp,eg,ep,ev,re,r,rp,chk,chkc)
	if chkc then return chkc:IsLocation(LOCATION_MZONE) and chkc:IsControler(tp) and Tenka.SugarEqFilter(chkc) and chkc~=e:GetHandler() end
	if chk==0 then return e:GetHandler():GetFlagEffect(m)==0 and Duel.GetLocationCount(tp,LOCATION_SZONE)>0
		and Duel.IsExistingTarget(Tenka.SugarEqFilter,tp,LOCATION_MZONE,0,1,e:GetHandler()) end
	Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_EQUIP)
	local g=Duel.SelectTarget(tp,Tenka.SugarEqFilter,tp,LOCATION_MZONE,0,1,1,e:GetHandler())
	Duel.SetOperationInfo(0,CATEGORY_EQUIP,g,1,0,0)
	e:GetHandler():RegisterFlagEffect(m,RESET_EVENT+0x7e0000+RESET_PHASE+PHASE_END,0,1)
end
function Tenka.SugarEqop(e,tp,eg,ep,ev,re,r,rp)
	local c=e:GetHandler()
	local tc=Duel.GetFirstTarget()
	if not c:IsRelateToEffect(e) or c:IsFacedown() then return end
	if not tc:IsRelateToEffect(e) or tc:IsFacedown() or tc:IsControler(1-tp) then
		Duel.SendtoGrave(c,REASON_EFFECT)
		return
	end
	if not Duel.Equip(tp,c,tc,false) then return end
	--eqlimit
	local e4=Effect.CreateEffect(c)
	e4:SetType(EFFECT_TYPE_SINGLE)
	e4:SetCode(EFFECT_EQUIP_LIMIT)
	e4:SetProperty(EFFECT_FLAG_CANNOT_DISABLE)
	e4:SetValue(Tenka.SugarEqlimit)
	e4:SetReset(RESET_EVENT+RESETS_STANDARD)
	e4:SetLabelObject(tc)
	c:RegisterEffect(e4)
end
function Tenka.SugarEqlimit(e,c)
	return c==e:GetLabelObject()
end
function Tenka.SugarSptg(e,tp,eg,ep,ev,re,r,rp,chk)
	local c=e:GetHandler()
	if chk==0 then return c:GetFlagEffect(m)==0 and Duel.GetLocationCount(tp,LOCATION_MZONE)>0
		and c:GetEquipTarget() and c:IsCanBeSpecialSummoned(e,0,tp,false,false,POS_FACEUP) end
	Duel.SetOperationInfo(0,CATEGORY_SPECIAL_SUMMON,c,1,0,0)
	c:RegisterFlagEffect(m,RESET_EVENT+0x7e0000+RESET_PHASE+PHASE_END,0,1)
end
function Tenka.SugarSpop(e,tp,eg,ep,ev,re,r,rp)
	local c=e:GetHandler()
	if not c:IsRelateToEffect(e) then return end
	Duel.SpecialSummon(c,0,tp,tp,false,false,POS_FACEUP)
end
--SugarRush
function Tenka.SugarRushCost(e,tp,eg,ep,ev,re,r,rp,chk)
	if chk==0 then return Duel.IsExistingMatchingCard(Tenka.SugarRushFilter,tp,LOCATION_SZONE,0,1,nil) end
	Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_TOGRAVE)
	local g=Duel.SelectMatchingCard(tp,Tenka.SugarRushFilter,tp,LOCATION_SZONE,0,1,1,nil)
	Duel.SendtoGrave(g,REASON_COST)
end
function Tenka.SugarRushFilter(c)
	return c:IsFaceup() and c:GetEquipTarget() and c:GetEquipTarget():IsAttack(1550) and c:GetEquipTarget():IsDefense(1050) and c:IsAbleToGraveAsCost()
end
--SugarEquip
function Tenka.SugarEquip(c)
	--Activate
	local ea=Effect.CreateEffect(c)
	ea:SetCategory(CATEGORY_EQUIP)
	ea:SetType(EFFECT_TYPE_ACTIVATE)
	ea:SetCode(EVENT_FREE_CHAIN)
	ea:SetProperty(EFFECT_FLAG_CARD_TARGET+EFFECT_FLAG_CONTINUOUS_TARGET)
	ea:SetTarget(Tenka.SugarEquipTg)
	ea:SetOperation(Tenka.SugarEquipOp)
	c:RegisterEffect(ea)
	--Equip limit
	local eb=Effect.CreateEffect(c)
	eb:SetType(EFFECT_TYPE_SINGLE)
	eb:SetCode(EFFECT_EQUIP_LIMIT)
	eb:SetProperty(EFFECT_FLAG_CANNOT_DISABLE)
	eb:SetValue(1)
	c:RegisterEffect(eb)
end
function Tenka.SugarEquipTg(e,tp,eg,ep,ev,re,r,rp,chk,chkc)
	if chkc then return chkc:IsLocation(LOCATION_MZONE) and chkc:IsFaceup() end
	if chk==0 then return Duel.IsExistingTarget(Card.IsFaceup,tp,LOCATION_MZONE,LOCATION_MZONE,1,nil) end
	Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_EQUIP)
	Duel.SelectTarget(tp,Card.IsFaceup,tp,LOCATION_MZONE,LOCATION_MZONE,1,1,nil)
	Duel.SetOperationInfo(0,CATEGORY_EQUIP,e:GetHandler(),1,0,0)
end
function Tenka.SugarEquipOp(e,tp,eg,ep,ev,re,r,rp)
	local tc=Duel.GetFirstTarget()
	if e:GetHandler():IsRelateToEffect(e) and tc:IsRelateToEffect(e) and tc:IsFaceup() then
		Duel.Equip(tp,e:GetHandler(),tc)
	end
end
function Tenka.SugarEquipCon(e,tp,eg,ep,ev,re,r,rp)
	return e:GetHandler():IsReason(REASON_COST) and re:IsActivated() and re:IsActiveType(TYPE_MONSTER)
		and re:GetHandler():IsAttack(1550) and re:GetHandler():IsDefense(1050)
end
--Yumeno
function Tenka.Yumeno(c)
	local ea=Effect.CreateEffect(c)
	ea:SetCategory(CATEGORY_DESTROY+CATEGORY_DAMAGE)
	ea:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_TRIGGER_F)
	ea:SetCode(EVENT_PHASE+PHASE_STANDBY)
	ea:SetRange(LOCATION_SZONE)
	ea:SetCountLimit(1)
	ea:SetCondition(Tenka.YumenoDescon)
	ea:SetTarget(Tenka.YumenoDestg)
	ea:SetOperation(Tenka.YumenoDesop)
	c:RegisterEffect(ea)
end
function Tenka.YumenoDescon(e,tp,eg,ep,ev,re,r,rp)
	return e:GetHandler():GetEquipTarget() and Duel.GetTurnPlayer()~=tp
end
function Tenka.YumenoDestg(e,tp,eg,ep,ev,re,r,rp,chk)
	if chk==0 then return true end
	local ec=e:GetHandler():GetEquipTarget()
	ec:CreateEffectRelation(e)
	e:SetLabelObject(ec)
	Duel.SetOperationInfo(0,CATEGORY_DESTROY,ec,1,0,0)
	Duel.SetOperationInfo(0,CATEGORY_DAMAGE,nil,0,1-tp,ec:GetAttack())
end
function Tenka.YumenoDesop(e,tp,eg,ep,ev,re,r,rp)
	local c=e:GetHandler()
	if not c:IsRelateToEffect(e) then return end
	local ec=e:GetLabelObject()
	if ec:IsRelateToEffect(e) and ec:IsFaceup() then
		local atk=ec:GetAttack()
		if Duel.Destroy(ec,REASON_EFFECT)~=0 then
			Duel.Damage(1-tp,atk,REASON_EFFECT)
		else Duel.Destroy(c,REASON_EFFECT) end
	end
end
