========== Card ==========
●int Card.GetCode(Card c)
返回c的当前代号（可能因为效果改变）
●int Card.GetOriginalCode(Card c)
返回c的卡片记载的代号
●bool Card.IsSetCard(Card c, int setname)
检查c是否是名字含有setname的卡
●int Card.GetType(Card c)
返回c的当前类型。
●int Card.GetOriginalType(Card c)
返回c的卡片记载的类型。
●int Card.GetLevel(Card c)
返回c的当前等级
●int Card.GetSynchroLevel(Card c)
返回c的同调用等级。此函数除了某些特定卡如调节支援士，
返回值与Card.GetLevel(c)相同
●int Card.GetRitualLevel(Card c)
返回c的仪式解放等级。此函数除了某些特定卡如仪式供物，
返回值与Card.GetLevel(c)相同
●int Card.GetOriginalLevel(Card c)
返回c的卡片记载的等级
●int Card.GetAttribute(Card c)
返回c的当前属性。注：对某些多属性怪物如光与暗之龙，
此函数的返回值可能是几个属性的组合值。
●int Card.GetOriginalAttribute(Card c)
返回c的卡片记载的属性
●int Card.GetRace(Card c)
返回c的当前种族。注：对某些多种族怪物如动画效果的魔术猿，
此函数的返回值可能是几个种族的组合值。
●int Card.GetOriginalRace(Card c)
返回c的卡片记载的种族
●int Card.GetAttack(Card c)
返回c的当前攻击力，返回值是负数表示是"?"
●int Card.GetBaseAttack(Card c)
返回c的原本攻击力
●int Card.GetTextAttack(Card c)
返回c的卡片记载的攻击力
●int Card.GetDefence(Card c)
返回c的当前守备力，返回值是负数表示是"?"
●int Card.GetBaseDefence(Card c)
返回c的原本守备力
●int Card.GetTextDefence(Card c)
返回c的卡片记载的守备力
●int Card.GetOwner(Card c)
返回c的持有者
●int Card.GetControler(Card c)
返回c的当前控制者
●int Card.GetPreviousControler(Card c)
返回c的位置变化之前的控制者
●int Card.GetReason(Card c)
返回c的位置变化原因
●Card Card.GetReasonCard(Card c)
返回导致c的位置变化的卡。此函数仅在某卡被战斗破坏时，
因为上级召唤被解放，或者成为特殊召唤使用的素材时有效。
●Effect Card.GetReasonEffect(Card c)
返回导致c的位置变化的效果。
●int Card.GetPosition(Card c)
返回c当前的表示形式
●int Card.GetPreviousPosition(Card c)
返回c位置变化前的表示形式
●int Card.GetBattlePosition(Card c)
返回c在本次战斗发生之前的表示形式
●int Card.GetLocation(Card c)
返回c当前的所在位置
●int Card.GetPreviousLocation(Card c)
返回c位置变化前的所在的位置
●int Card.GetSequence(Card c)
返回c在当前位置的序号
在场上时，序号代表所在的格子，从左往右分别是0-4，场地魔法格的序号为5
在其它地方时，序号表示的是第几张卡。最底下的卡的序号为0
●int Card.GetPreviousSequence(Card c)
返回c位置变化前的序号
●int Card.GetSummonType(Card c)
返回c上场的方式。
●int Card.GetSummonPlayer(Card c)
返回召唤，特殊召唤c上场的玩家
●int Card.GetDestination(Card c)
返回c位置变化的目的地。此函数仅在处理位置转移代替效果时有效。
●int Card.GetTurnID(Card c)
返回c转移到当前位置的回合
●int Card.GetFieldID(Card c)
返回c转移到当前位置的时间标识。此数值唯一，越小表示c是越早出现在那个位置。
●bool Card.IsCode(Card c, int code)
检查c的代号是否是code。
●bool Card.IsType(Card c, int type)
检查c是否属于类型type。
●bool Card.IsRace(Card c, int race)
检查c是否属于种族race。
●bool Card.IsAttribute(Card c, int attribute)
检查c是否属于属性attribute。
●bool Card.IsReason(Card c, int reason)
检查c是否包含原因reason。
●bool Card.IsStatus(Card c, int status)
检查c是否包含某个状态码。
●bool Card.IsNotTuner(Card c)
检查c是否可以当成非调整来使用。
●void Card.SetStatus(Card c, int state, bool enable)
给c设置或者取消状态码。除非妳清楚的了解每个状态码的含意，否则不要轻易使用此函数。
●bool Card.IsDualState(Card c)
检查c属否处于再召唤状态。
●void Card.EnableDualState(Card c)
把c设置成再召唤状态。
●void Card.SetTurnCounter(Card c, int counter)
设置c的回合计数器(光之护封剑等)
●int Card.GetTurnCounter(Card c)
返回c的回合计数器
●void Card.SetCustomValue(Card c, string tag, any object)
以tag作为标签为c设置一个自定义值object
●any Card.GetCustomValue(Card c, string tag)
返回c的以tag作为标签的自定义值
●void Card.SetMaterial(Card c, Group g)
把g中的所有卡作为c的素材（上级召唤，特殊召唤）
●Group Card.GetMaterial(Card c)
返回c出场使用的素材
●int Card.GetMaterialCount(Card c)
返回c出场使用的素材数量
●Group Card.GetEquipGroup(Card c)
返回c当前装备着的卡片组
●int Card.GetEquipCount(Card c)
返回c当前装备着的卡片数量
●Card Card.GetEquipTarget(Card c)
返回c当前的装备对象
●bool Card.CheckEquipTarget(Card c1, Card c2)
检查c2是否是c1的正确的装备对象
●int Card.GetUnionCount(Card c)
返回c当前装备的同盟卡数量
●Group Card.GetOverlayGroup(Card c)
返回c当前叠放着的卡片组
●int Card.GetOverlayCount(Card c)
返回c当前叠放着的卡片数量
●int Card.RemoveOverlayCard
(Card c,int player, int min, int max, int reason)
以reason为原因，让玩家player移除c叠放的min-max张卡
●Group Card.GetAttackGroup(Card c)
返回c本回合攻击过的卡片组
●int Card.GetAttackedGroupCount(Card c)
返回c本回合攻击过的卡片数量
●int Card.GetAttackedCount(Card c)
返回c本回合攻击过的次数
注：如果此值与上一个函数的返回值不同，那么说明此卡本回合进行过直接攻击
●Group Card.GetBattledGroup(Card c)
返回与c本回合进行过战斗的卡片组
进行过战斗指发生过伤害的计算。用于剑斗兽等卡的判定。
●int Card.GetBattledGroupCount(Card c)
返回与c本回合进行过战斗的的卡片数量
●int Card.GetAttackAnnouncedCount(Card c)
返回c本回合攻击宣言的次数
注：攻击被无效不会被计入攻击过的次数，但是会计入攻击宣言的次数。
●void Card.SetCardTarget(Card c1, Card c2)
把c2作为c1的永续对象。
c1和c2的联系会在c1活c2任意一卡离场或变成里侧表示时reset。
●Group Card.GetCardTarget(Card c)
返回c当前所有的永续对象
●int Card.GetCardTargetCount(Card c)
返回c当前的永续对象的数量
●bool Card.IsHasCardTarget(Card c1, Card c2)
检查c1是否取c2为永续对象
●Group Card.GetOwnerTarget(Card c)
返回取c作为永续对象的所有卡
●int Card.GetOwnerTargetCount(Card c)
返回取c作为永续对象的卡的数量
●Effect Card.GetActivateEffect(Card c)
返回c的“卡片发动”的效果。仅对魔法和陷阱有效。
●int Card.RegisterEffect(Card c, Effect e, [bool forced=false])
把效果e注册给c，返回效果的全局id。
默认情况下注册时如果c带有免疫e的效果那么注册会失败。
如果forced为true则不会检查c对e的免疫效果。
●bool Card.IsHasEffect(Card c, int code)
检查c是否受到效果种类是code的效果的影响
●int Card.GetEffectCount(Card c, int code)
返回c受到影响的种类是code的效果的数量
●Effect Card.RegisterFlagEffect(Card c, int code, int reset_flag, int property, int reset_count
    [,int label,int desc])
为c注册一个标识用效果。
注：注册给卡的标识用效果不会用于系统，
即使code与内置效果code重合也不会影响，
并且类型总是EFFECT_TYPE_SINGLE。reset方法，property和一般的效果相同，
并且不会无效化，不受卡的免疫效果影响。
●int Card.GetFlagEffect(Card c, int code)
返回c的种类是code的标识效果的数量。
●void Card.ResetFlagEffect(Card c, int code)
手动清除c的种类是code的标识效果。
●void Card.CreateRelation(Card c1, Card c2, int reset_flag)
为c1建立于c2的联系。此联系仅会由于RESET_EVENT的事件reset。
●void Card.ReleaseRelation(Card c1, Card c2)
手动释放c1对于c2的联系
●bool Card.IsRelateToEffect(Card c, Effect e)
检查c是否和效果e有联系。
注：每次发动进入连锁的效果时，发动效果的卡，以及发动效果时指定的对象
（用Duel.SetTargetCard或者Duel.SelectTarget指定的，包括取对象和不取对象）
会自动与那个效果建立联系。一旦离场，联系会重置。
●bool Card.IsRelateToCard(Card c1, Card c2)
检查c1是否和c2有联系。
●bool Card.IsRelateToBattle(Card c)
检查c是否和本次战斗关联。
注：此效果通常用于伤害计算后伤害阶段结束前，用于检查战斗的卡是否离场过。
●int Card.CopyEffect(Card c, int code, int reset_flag,int reset_count)
为c添加代号是code的卡的可复制的效果，并且添加额外的reset条件。
返回值是表示复制效果的代号id。
●void Card.EnableReviveLimit(Card c)
为c添加苏生限制。此函数也可通过Card.SetStatus实现。
●void Card.CompleteProcedure(Card c)
使c完成正规的召唤手续。此函数也可通过Card.SetStatus实现。
●bool Card.IsDisabled(Card c)
检查c是否处于无效状态
●bool Card.IsDestructable(Card c[,Effect e])
检查c是否是可破坏的。
注：不可破坏指的是类似场地护罩，宫廷的规矩等“破壊できない”的效果
●bool Card.IsSummonableCard(Card c[,bool ignore,Effect e])
检查c是否是可通常召唤的卡。
●bool Card.IsSpecialSummonable(Card c)
检查是否可以对c进行特殊召唤手续。
●bool Card.IsSynchroSummonable(Card c [,Card tuner=nil,Group mg])
检查是否可以以tuner作为调整对c进行同调召唤手续。
如果tuner是nil，此函数与上一个函数作用相同。
●bool Card.IsSummonable(Card c)
检查c是否可进行通常召唤（不包含通常召唤的set)
●bool Card.IsMSetable(Card c)
检查c是否可进行通常召唤的set
●bool Card.IsSSetable(Card c)
检查c是否可以set到魔法陷阱区
●bool Card.IsCanBeSpecialSummoned(Card c, Effect e, int sumtype, int sumplayer, 
bool nocheck, bool nolimit, [int sumpos=POS_FACEUP, int target_player=sumplayer])
检查c是否可以被玩家sumplayer
用效果e以sumtype方式和sumpos表示形式特殊召唤到target_player场上。
如果nocheck是true则不检查c的召唤条件，如果nolimit是true则不检查c的苏生限制。
●bool Card.IsAbleToHand(Card c)
检查c是否可以送去手牌。
注：仅当卡片或者玩家受到“不能加入手牌”的效果的影响时（如雷王）此函数才返回false。
以下几个函数类似。
●bool Card.IsAbleToDeck(Card c)
检查c是否可以送去卡组。
●bool Card.IsAbleToExtra(Card c)
检查c是否可以送去额外卡组。
对于非融合，同调，超量卡此函数均返回false。
●bool Card.IsAbleToGrave(Card c)
检查c是否可以送去墓地。
●bool Card.IsAbleToRemove(Card c)
检查c是否可以除外。
●bool Card.IsAbleToHandAsCost(Card c)
检查c是否可以作为cost送去手牌。
注：此函数会在Card.IsAbleToHand的基础上追加检测c的实际目的地。
当c送往手牌会被送去其它地方时（如缩退回路适用中，或者c是融合，同调和超量怪的一种），
此函数返回false。以下几个函数类似。
●bool Card.IsAbleToDeckAsCost(Card c)
检查c是否可以作为cost送去卡组。
●bool Card.IsAbleToExtraAsCost(Card c)
检查c是否可以作为cost送去额外卡组。
●bool Card.IsAbleToGraveAsCost(Card c)
检查c是否可以作为cost送去墓地。
●bool Card.IsAbleToRemoveAsCost(Card c)
检查c是否可以作为cost除外。
●bool Card.IsReleaseable(Card c)
检查c是否可以解放（非上级召唤用）
●bool Card.IsDiscardable(Card c)
检查c是否可以丢弃
注：此函数仅用于检测，
以REASON_DISCARD作为原因把一张手卡送墓并不会导致那张卡不能丢弃。
●bool Card.IsAttackable(Card c)
检查c是否可以攻击
●bool Card.IsChainAttackable(Card c)
检查c是否可以连续攻击
注：当c因为闪光之双剑等效果进行过多次攻击之后此函数返回false。
●bool Card.IsFaceup(Card c)
检查c是否是表侧表示
●bool Card.IsFacedown(Card c)
检查c是否是里侧测表示
●bool Card.IsAttack(Card c)
检查c是否是攻击表示
●bool Card.IsDefence(Card c)
检查c是否是守备表示
●bool Card.IsControler(Card c, int con)
检查c的当前控制着是否是con
●bool Card.IsOnField(Card c)
检查c是否在场。
注：当怪物召唤，反转召唤，特殊召唤时召唤成功之前，此函数返回false
●bool Card.IsLocation(Card c, int loc)
检查c当前位置是否是loc。
注：当怪物召唤，反转召唤，特殊召唤时召唤成功之前，
并且loc=LOCATION_MZONE时，此函数返回false
●bool Card.IsPublic(Card c)
检查c是否处于公开状态
●bool Card.IsForbidden(Card c)
检查c是否处于被宣言禁止状态
●bool Card.IsAbleToChangeControler(Card c)
检查c是否可以改变控制权
注：仅当卡收到了“不能改变控制权”的效果的影响时，此函数返回false
●bool Card.IsControlerCanBeChanged(Card c)
检查c的控制权是否可以改变
注：此函数会在上一个函数的基础上追加检测场上的空格位
●void Card.AddCounter(Card c, int countertype, int count)
为c放置count个countertype类型的指示物
●void Card.RemoveCounter(Card c, int player, int countertype,
 int count, int reason)
让玩家player以原因reason移除c上的count个countertype类型的指示物
●int Card.GetCounter(Card c, int countertype)
返回c上的countertype类型的指示物的数量
●void Card.EnableCounterPermit(Card c, int countertype)
允许c放置那个需要“可以放置”才能放置的指示物countertype
●void Card.SetCounterLimit(Card c, int countertype, int count)
设定c放置countertype类型指示物的上限
●bool Card.IsCanTurnSet(Card c)
检查c是否可以转成里侧表示。
●bool Card.IsCanAddCounter(Card c, int countertype, int count)
检查c是否可以放置count个countertype类型的指示物
●bool Card.IsCanRemoveCounter(Card c, int player, int countertype, 
int count, int reason)
检查玩家player是否可以以原因reason移除c上的count个countertype类型的指示物
●bool Card.IsCanBeFusionMaterial(Card c)
检查c是否可以成为融合素材
●bool Card.IsCanBeSynchroMaterial(Card c[,Card scard,Card tuner])
检查c是否可以成为同调素材
●bool Card.IsCanBeExceedMaterial(Card c)
检查c是否可以成为超量素材
●bool Card.CheckFusionMaterial(Card c, Group g[, Card cg, int chkf=PLAYER_NONE])
检查g是否包含了c需要的一组融合素材
●bool Card.IsImmuneToEffect(Card c, Effect e)
检查c是否免疫效果e（即不受效果e的影响）
●bool Card.IsCanBeEffectTarget(Card c, Effect e)
检查c是否可以成为效果e的对象
●bool Card.IsCanBeBattleTarget(Card c1, Card c2)
检查c1是否可以成为c2的攻击目标
●void Card.AddTrapMonsterAttribute(Card c, int extra_type,int attribute,int race,int level,int atk,int def)
【新】为c添加陷阱怪物属性。
	extra_type 额外卡片类型
●void Card.AddTrapMonsterAttribute(Card c, bool is_effect)
【旧】为c添加陷阱怪物属性。is_effect=true表示视作效果怪物，否则视为通常怪物
注：陷阱怪物属性指的是同时作为怪物和陷阱，
并且额外使一个魔法陷阱的格子不能使用。
●void Card.CancelToGrave(Card c)
取消送墓确定状态。
注：送墓确定状态指的是在场上发动的不留场的魔法和陷阱后，这些卡片的状态。
送墓确定状态中的卡无法返回手牌和卡组，并且连锁结束时送去墓地。
此函数的作用是取消此状态使其留场。用于光之护封剑和废铁稻草人等卡。
●int,int Card.GetTributeRequirement(Card c)
返回通常召唤c所需要的祭品的最小和最大数量
●void Card.AssumeProperty(Card c,int assume_type, int assume_value)
●void Card.CancelCardTarget(Card pcard, Card rcard)
●void Card.CancelToGrave(Card c [,bool cancel])
取消送墓
●int Card.CheckActivateEffect(Card c, bool neglect_con, bool neglect_cost, bool copy_info)
●bool Card.CheckRemoveOverlayCard(Card c,int playerid,int count,int reason)
●bool Card.CheckUniqueOnField(Card c,int check_player)
●void Card.ClearEffectRelation(Card c)
●void Card.CreateEffectRelation(Card c, Effect e)
●bool Card.GetAttackableTarget(Card c)
●Group Card.GetAttackedGroup(Card c)
●Card Card.GetBattleTarget(Card c)
●Card Card.GetFirstCardTarget(Card c)
●int Card.GetFlagEffectLabel(Card c)
nil
●Card.GetLeaveFieldDest(Card c)
●int Card.GetOriginalRank(Card c)
●Card Card.GetOverlayTarget(Card c)
●int Card.GetPreviousAttackOnField(Card c)
●int Card.GetPreviousAttributeOnField(Card c)
●int Card.GetPreviousCodeOnField(Card c)
●int Card.GetPreviousDefenceOnField(Card c)
●Card Card.GetPreviousEquipTarget(Card)
●int Card.GetPreviousLevelOnField(Card c)
●int Card.GetPreviousRaceOnField(Card c)
●int Card.GetPreviousRankOnField(Card c)
●int Card.GetPreviousTypeOnField(Card c)
●int Card.GetRank(Card c)
●int Card.GetRealFieldID(Card c)
●int Card.GetReasonPlayer(Card c)
●int Card.GetRightScale(Card c)
●int Card.GetSummonType(Card c)
●bool Card.IsAttackAbove(Card c,int atk)
●bool Card.IsAttackBelow(Card c,int atk)
●bool Card.IsAttackPos(Card c)
●bool Card.IsCanBeXyzMaterial(Card c,Card scard)
●bool Card.IsDefenceAbove(Card c,int def)
●bool Card.IsDefenceBelow(Card c,int def)
●bool Card.IsDefencePos(Card c)
●bool Card.IsDirectAttacked(Card c)
●bool Card.IsLevelAbove(Card c,int level)
●bool Card.IsLevelBelow(Card c,int level)
●bool Card.IsPosition(Card c.int pos)
●bool Card.IsPreviousLocation(Card c,int location)
●bool Card.IsPreviousPosition(Card c,int pos)
●bool Card.IsRankAbove(Card c,int rank)
●bool Card.IsRankBelow(Card c,int rank)
●bool Card.IsReleasable(Card c)
●bool Card.IsReleasableByEffect(Card c)
●bool Card.IsXyzLevel(Card c,Card xyzcard,int level)
●bool Card.IsXyzSummonable(Card c [,Group mg])
●void Card.ReleaseEffectRelation(Card c,Effect e)
●void Card.ResetEffect(Card,int code,int type)
●void Card.ResetNegateEffect(Card c [,int i,...])
●void Card.ResetNegateEffect(Card c [,int i,...])
●void Card.ReverseInDeck(Card c)
●bool Card.SetFlagEffectLabel(Card c,int code,int label)
●void Card.SetHint(Card c,int type,int value)
●void Card.SetUniqueOnField(Card c,int pos1,int pos2,int code)
●void Card.TrapMonsterBlock(Card c)