﻿using YGOSharp.OCGWrapper.Enums;
using System.Collections.Generic;
using System.Linq;
using WindBot;
using WindBot.Game;
using WindBot.Game.AI;
using System;

namespace WindBot.Game.AI.Decks
{
    [Deck("MathMech", "AI_Mathmech")]
    public class MathMechExecutor : DefaultExecutor
    {
        public class CardId
        {
            public const int 最强战旗 = 120181001;
            public const int 钢机神 = 120155015;
            public const int 连击龙 = 120110001;
            public const int 恶德 = 120183024;
            public const int 旗兽 = 120193002;
            public const int 社员 = 120183002;

            public const int 成金恐龙王 = 120151010;       
            public const int 突击坦克 = 120183031;
            public const int 工匠无人机 = 120183030;
            public const int 双角兽 = 120181011;
            public const int 瞄准鹰 = 120193003;
            public const int 死苏 = 120194004;            
            public const int 世纪末兽机界 = 120130039;
            public const int 铁之重击 = 120183054;
            public const int 对死者的供奉 = 120151023;

            public const int 兽之拳 = 120155060;
            public const int 减俸 = 120183062;
            public const int 左迁 = 120183063;
            public const int 冻结 = 120183064;
        }

        public MathMechExecutor(GameAI ai, Duel duel)
            : base(ai, duel)
        {
            AddExecutor(ExecutorType.SpSummon);
            AddExecutor(ExecutorType.Activate, CardId.铁之重击);           
            AddExecutor(ExecutorType.Activate, CardId.成金恐龙王);
            AddExecutor(ExecutorType.Activate, CardId.恶德, 恶德Effect);
            AddExecutor(ExecutorType.Activate, CardId.对死者的供奉, 死供Eff);            
            AddExecutor(ExecutorType.Activate, CardId.最强战旗, 最强战旗Eff);           
            AddExecutor(ExecutorType.Activate, CardId.突击坦克, 突击坦克Effect); 
            AddExecutor(ExecutorType.Activate, CardId.瞄准鹰, 瞄准鹰Effect);
            AddExecutor(ExecutorType.Activate, CardId.双角兽, 双角兽Effect);
            AddExecutor(ExecutorType.Repos, CardId.最强战旗, DefaultMonsterRepos);
            AddExecutor(ExecutorType.Repos, CardId.钢机神, DefaultMonsterRepos);
            AddExecutor(ExecutorType.Repos, CardId.恶德, DefaultMonsterRepos);
            AddExecutor(ExecutorType.Summon, CardId.最强战旗, DefaultDoubleSummon);
            AddExecutor(ExecutorType.Summon, CardId.钢机神, DefaultDoubleSummon);
            AddExecutor(ExecutorType.Summon, CardId.恶德, DefaultDoubleSummon);
            AddExecutor(ExecutorType.Summon, CardId.最强战旗, DefaultMonsterSummon);
            AddExecutor(ExecutorType.Summon, CardId.钢机神, DefaultMonsterSummon);
            AddExecutor(ExecutorType.Summon, CardId.恶德, DefaultMonsterSummon);

            AddExecutor(ExecutorType.Summon, CardId.双角兽, 双角兽summon);
            AddExecutor(ExecutorType.Summon, CardId.成金恐龙王, 成金恐龙王Summon);
            AddExecutor(ExecutorType.Summon, CardId.瞄准鹰, 瞄准鹰summon);
            AddExecutor(ExecutorType.Summon, CardId.瞄准鹰, 瞄准鹰summon2);
            AddExecutor(ExecutorType.Summon, CardId.瞄准鹰, 瞄准鹰summon3);
            AddExecutor(ExecutorType.Summon, CardId.双角兽, 瞄准鹰双角兽summon);            
            AddExecutor(ExecutorType.Summon, CardId.成金恐龙王, 瞄准鹰成金恐龙王summon);
            AddExecutor(ExecutorType.Summon, CardId.突击坦克, 瞄准鹰坦克summon);         
            AddExecutor(ExecutorType.Activate, CardId.最强战旗, 最强战旗Effect);
            AddExecutor(ExecutorType.Activate, CardId.对死者的供奉, 死供Effect);
            AddExecutor(ExecutorType.Activate, CardId.钢机神, 钢机神Effect);
            AddExecutor(ExecutorType.Activate, CardId.钢机神, 钢机神1Effect);
            AddExecutor(ExecutorType.MonsterSet, CardId.成金恐龙王);
            AddExecutor(ExecutorType.Activate, CardId.工匠无人机,无人机Effect);
            AddExecutor(ExecutorType.Summon, CardId.工匠无人机);
            AddExecutor(ExecutorType.Summon, CardId.突击坦克, 突击坦克summon);
            AddExecutor(ExecutorType.Activate, CardId.死苏, 死苏effect);          
            
            AddExecutor(ExecutorType.SummonOrSet, CardId.旗兽, DefaultMonsterSummon);
            AddExecutor(ExecutorType.SummonOrSet, CardId.社员, DefaultMonsterSummon);
            AddExecutor(ExecutorType.MonsterSet, CardId.工匠无人机);
            AddExecutor(ExecutorType.MonsterSet, CardId.突击坦克);
            AddExecutor(ExecutorType.MonsterSet, CardId.瞄准鹰);
            AddExecutor(ExecutorType.MonsterSet, CardId.双角兽);
            AddExecutor(ExecutorType.Activate, CardId.世纪末兽机界, DefaultField);
            AddExecutor(ExecutorType.Activate, CardId.兽之拳,兽之拳Effect);
            AddExecutor(ExecutorType.Activate, CardId.左迁, 左迁1Effect); 
            AddExecutor(ExecutorType.Activate, CardId.减俸);
            AddExecutor(ExecutorType.Activate, CardId.左迁,左迁2Effect);
            AddExecutor(ExecutorType.Activate, CardId.冻结,冻结Effect);
            AddExecutor(ExecutorType.Activate, CardId.兽之拳);

            AddExecutor(ExecutorType.Activate, DefaultDontChainMyself);
            AddExecutor(ExecutorType.Repos, CardId.最强战旗, 圣防Repos);
            AddExecutor(ExecutorType.Repos, CardId.钢机神, 圣防Repos);
            AddExecutor(ExecutorType.SummonOrSet, DefaultMonsterSummon);
            AddExecutor(ExecutorType.Repos, DefaultMonsterRepos);           
            AddExecutor(ExecutorType.SpellSet, DefaultSpellSet);
            AddExecutor(ExecutorType.SpellSet, CardId.铁之重击);
            AddExecutor(ExecutorType.SpellSet, CardId.死苏);
            AddExecutor(ExecutorType.SpellSet, CardId.对死者的供奉);
        }



        private List<int> HintMsgForEnemy = new List<int>
        {
            HintMsg.Release, HintMsg.Destroy, HintMsg.Remove, HintMsg.ToGrave, HintMsg.ReturnToHand, HintMsg.ToDeck,
            HintMsg.FusionMaterial, HintMsg.SynchroMaterial, HintMsg.XyzMaterial, HintMsg.LinkMaterial, HintMsg.Disable
        };
        private List<int> HintMsgForMaxSelect = new List<int>
        {
            HintMsg.SpSummon, HintMsg.ToGrave, HintMsg.AddToHand, HintMsg.ToDeck, HintMsg.Destroy
        };

        public override IList<ClientCard> OnSelectCard(IList<ClientCard> _cards, int min, int max, int hint, bool cancelable)
        {
            if (Duel.Phase == DuelPhase.BattleStart)
                return null;
            if (AI.HaveSelectedCards())
                return null;

            IList<ClientCard> selected = new List<ClientCard>();
            IList<ClientCard> cards = new List<ClientCard>(_cards);
            if (max > cards.Count)
                max = cards.Count;

            if (HintMsgForEnemy.Contains(hint))
            {
                IList<ClientCard> enemyCards = cards.Where(card => card.Controller == 1).ToList();

                // select enemy's card first
                while (enemyCards.Count > 0 && selected.Count < max)
                {
                    ClientCard card = enemyCards[Program.Rand.Next(enemyCards.Count)];
                    selected.Add(card);
                    enemyCards.Remove(card);
                    cards.Remove(card);
                }
            }

             if (HintMsgForMaxSelect.Contains(hint))
            {
                  //select max cards
                while (selected.Count < max)
                {
                     ClientCard card = cards[Program.Rand.Next(cards.Count)];
                   selected.Add(card);
                     cards.Remove(card);
                 }
             }
             return selected;
        }

        public override bool OnSelectHand()
        {
            // go first
            return true;
        }

        bool DoubleTribute = false;
        public override void OnNewTurn()
        {
            DoubleTribute = false;
        }
        private bool DefaultDoubleSummon()
        {           
            if (!DoubleTribute) return false;
            else
                AI.SelectCard(CardId.双角兽);
                DoubleTribute = false;
                return true;                 
        }
        private bool 左迁1Effect()
        {
            
        if (Enemy.BattlingMonster.Attack > 2000)
            {
            AI.SelectCard(Enemy.BattlingMonster);
            return true;
            }
            return false;
        }
        private bool 左迁2Effect()
        {
            ClientCard target = Util.GetBestEnemyMonster(true, true);
            if (target != null)
                AI.SelectCard(target);
            return true;        
        }
        private bool 冻结Effect()
        {
            foreach (ClientCard monster in Bot.GetMonsters())
            {
                if (monster.IsFacedown())
                {
                    AI.SelectCard(monster);
                    return true;
                }
                else if (monster.IsDefense())
                {
                    AI.SelectCard(monster);
                    return true;
                }
            }
            AI.SelectCard(Bot.MonsterZone.GetLowestAttackMonster());
            return true;
        }
        private bool 钢机神Effect()
        {            
            if (Duel.Turn == 1) return false;
            else if (Enemy.HasAttackingMonster() || Enemy.GetMonsterCount() < 1)
                AI.SelectCard(CardId.最强战旗, CardId.钢机神, CardId.恶德, CardId.旗兽, CardId.突击坦克, CardId.工匠无人机, CardId.社员, CardId.双角兽, CardId.瞄准鹰);
            return true;
        }
        private bool 钢机神1Effect()
        {            
            if (!Enemy.HasAttackingMonster() && Enemy.GetMonsterCount() >= 1)
            {
                AI.SelectCard(Bot.Graveyard.GetHighestAttackMonster());
                return true;
            }
            return false;
        }
        private bool 恶德Effect()
        {
            foreach (ClientCard m in Bot.Hand)
                AI.SelectCard(m);
            AI.SelectNextCard(CardId.左迁, CardId.减俸);
            AI.SelectNextCard(CardId.左迁, CardId.减俸);
            return true;
            
        }
        private bool 兽之拳Effect()
        {
            if (Enemy.BattlingMonster.Race == (int)CardRace.Dragon)
                return true;
            if (Enemy.BattlingMonster.Race == (int)CardRace.Fairy)
                return true;
            if (Enemy.BattlingMonster.Race == (int)CardRace.SpellCaster)
                return true;
            return false;
        }

        private bool 死苏effect()
        {
            if (!Util.IsAllEnemyBetter(true))
                return false;
            ClientCard selected = Enemy.Graveyard.GetMatchingCards(card => card.IsCanRevive()).OrderByDescending(card => card.Attack).FirstOrDefault();
            if (selected.Attack >=2400)
            {
                AI.SelectCard(selected);
            return true;
            }
            return false;
        }
        private bool 成金恐龙王Summon()
        {
            if (Enemy.GetHandCount() < 1) return true;
            return false;
        }
        private bool 死供Effect()
        {
            if (Util.IsOneEnemyBetterThanValue(1900, false))
            {
                foreach (ClientCard m in Bot.Hand)
                    AI.SelectCard(m);
                foreach (ClientCard mon in Enemy.GetMonsters())
                    if (mon.Level >= 9)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 8)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 7)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 5)
                        AI.SelectNextCard(mon);
                return true;
            }
            return false;
        }
        private bool 死供Eff()
        {
            if (Util.IsOneEnemyBetterThanValue(2600, false))
            {
                foreach (ClientCard m in Bot.Hand)
                    AI.SelectCard(m);
                foreach (ClientCard mon in Enemy.GetMonsters())
                    if (mon.Level >= 8)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 7)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 5)
                        AI.SelectNextCard(mon);
                return true;
            }
            return false;
        }
        private bool 突击坦克Effect()
        {           
            foreach (ClientCard mon in Enemy.GetMonsters())
                if (mon.Level >= 9)
                    AI.SelectCard(mon);
                else if (mon.Level >= 8)
                    AI.SelectCard(mon);
                else if (mon.Level >= 6)
                    AI.SelectCard(mon);
                else if (mon.Level >= 4)
                    AI.SelectCard(mon);
                else if (mon.Level >= 2)
                    AI.SelectCard(mon);
                else if (mon.Level >= 1)
                    AI.SelectCard(mon);
            return true;
        }
        private bool 突击坦克summon()
        {
            if (Bot.MonsterZone.GetMatchingCardsCount(card => (card.Race & (int)CardRace.Machine) > 0) == 2) return true;
            return false;
        }

        private bool 双角兽summon()
        {
            if (Bot.Graveyard.GetMatchingCardsCount(card => (card.Race & (int)CardRace.Machine) > 0) >= 3 && Bot.HasInHand(new[] { CardId.最强战旗, CardId.钢机神, CardId.恶德 })) 
                return true;
            return false;
        }
        private bool 双角兽Effect()
        {
            
            if (Bot.HasInHand(new[] { CardId.最强战旗, CardId.钢机神, CardId.恶德 }))
            {
                AI.SelectCard(CardId.瞄准鹰, CardId.双角兽, CardId.工匠无人机, CardId.突击坦克, CardId.社员, CardId.旗兽, CardId.恶德, CardId.钢机神, CardId.最强战旗);
                DoubleTribute = true;
                return true;
            }
            return false;
        }
        private bool 瞄准鹰双角兽summon()
        {
            if (Bot.HasInMonstersZone(CardId.瞄准鹰) && Bot.HasInHand(new[] { CardId.最强战旗, CardId.钢机神, CardId.恶德 }))
                return true;
            return false;
        }
        private bool 瞄准鹰坦克summon()
        {
            if (Bot.HasInMonstersZone(CardId.瞄准鹰) && Bot.HasInHand(new[] { CardId.最强战旗, CardId.钢机神, CardId.恶德 }))
                return true;
            return false;
        }
        private bool 瞄准鹰成金恐龙王summon()
        {
            if (Bot.HasInMonstersZone(CardId.瞄准鹰) && Bot.HasInHand(new[] { CardId.最强战旗, CardId.钢机神, CardId.恶德 }))
                return true;
            return false;
        }
        private bool 瞄准鹰summon()
        {           
          foreach (ClientCard m in Bot.GetMonsters())
               if (m.HasAttribute(CardAttribute.Light) && m.Level <= 4 && m.IsFaceup())
              if (Bot.HasInHand(new[] { CardId.最强战旗, CardId.钢机神, CardId.恶德 }))
             if (Enemy.MonsterZone.GetMatchingCardsCount(card => card.Level >= 7) > 0)                       
              return true;           
            return false;
        }
        private bool 瞄准鹰summon2()
        {
            if (Bot.GetCountCardInZone(Bot.Hand, CardId.瞄准鹰) >= 2 )
                if (Bot.HasInHand(new[] { CardId.最强战旗, CardId.钢机神, CardId.恶德 }))
                  if (Enemy.MonsterZone.GetMatchingCardsCount(card => card.Level >= 7) > 0)
                             return true;           
            return false;
        }
        private bool 瞄准鹰summon3()
        {
                     if (Bot.HasInHand(CardId.双角兽) || Bot.HasInHand(CardId.突击坦克) || Bot.HasInHand(CardId.成金恐龙王))
                if (Bot.HasInHand(new[] { CardId.最强战旗, CardId.钢机神, CardId.恶德 }))
                            if (Enemy.MonsterZone.GetMatchingCardsCount(card => card.Level >= 7) > 0)
                                return true;
            return false;
        }
        private bool 瞄准鹰Effect()
        {
           
            if (Bot.MonsterZone.GetMatchingCardsCount(card => card.Level <= 4 && card.IsFaceup()) >= 2 && Bot.HasInHand(new[] { CardId.最强战旗, CardId.钢机神, CardId.恶德, CardId.旗兽, CardId.社员 }))
            {
                AI.SelectCard(CardId.瞄准鹰,CardId.突击坦克, CardId.成金恐龙王, CardId.社员, CardId.旗兽);
            AI.SelectNextCard(CardId.瞄准鹰, CardId.突击坦克, CardId.成金恐龙王, CardId.社员, CardId.旗兽);
            AI.SelectThirdCard(CardId.最强战旗, CardId.钢机神, CardId.恶德, CardId.旗兽, CardId.社员);
            return true;
            }
            return false;
        }
        private bool 无人机Effect()
        {

            if ((Bot.MonsterZone.GetMatchingCardsCount(card => card.Level < 5)+ Bot.Hand.GetMatchingCardsCount(card => card.Level < 5)) <= 2 )
            {
                if (Bot.MonsterZone.GetMatchingCardsCount(card => card.Level > 5) > 2)
                    AI.SelectCard(CardId.最强战旗, CardId.钢机神, CardId.恶德);
               else if (Bot.MonsterZone.GetMatchingCardsCount(card => card.Level > 5) == 1 && (Bot.MonsterZone.GetMatchingCardsCount(card => card.Level < 5) + Bot.Hand.GetMatchingCardsCount(card => card.Level < 5)) == 1)
                {
                    AI.SelectCard(CardId.最强战旗, CardId.钢机神, CardId.恶德);
                return true;
                }
                return false;
            }
            else
            AI.SelectCard(CardId.瞄准鹰, CardId.突击坦克, CardId.工匠无人机, CardId.社员, CardId.旗兽);        
                return true;
        }
        private bool 最强战旗Effect()
    {
        if (Util.IsOneEnemyBetterThanValue(1900, false))
        {
            foreach (ClientCard m in Bot.Hand)          
                AI.SelectCard(m) ;
                foreach (ClientCard mon in Enemy.GetMonsters())
                if (mon.Level >= 9)
                    AI.SelectNextCard(mon);
                else if (mon.Level >= 8)
                    AI.SelectNextCard(mon);
                else if (mon.Level >= 7)
                    AI.SelectNextCard(mon);
                    else if (mon.Level >= 5)
                        AI.SelectNextCard(mon);
                return true;
        }
        return false;
    }
        private bool 最强战旗Eff()
        {
            if (Util.IsOneEnemyBetterThanValue(2500, false))
            {
                foreach (ClientCard m in Bot.Hand)
                    AI.SelectCard(m);
                foreach (ClientCard mon in Enemy.GetMonsters())
                    if (mon.Level >= 9)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 8)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 7)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 5)
                        AI.SelectNextCard(mon);
                return true;
            }
            return false;
        }
        private bool 圣防Repos()
        {
            if (Enemy.Graveyard.GetMatchingCardsCount(card => (card.Race & (int)CardRace.SpellCaster) > 0) >= 4 && Enemy.GetSpellCountWithoutField() >= 1)
            {
                if (Bot.MonsterZone.GetMatchingCardsCount(card => card.IsAttack() && card.Level >= 5) >= 2 && !Bot.HasDefendingMonster())
                    return true;
            }
            return false;
        }

    }
}








