-- Rush Duel 编号
RushDuel = RushDuel or {}

LEGEND_DARK_MAGICIAN = {120130000, 120203015}
LEGEND_BLUE_EYES_WHITE_DRAGON = {120120000, 120198001, 120230001}
LEGEND_RED_EYES_BLACK_DRAGON = {120125001, 120203016, 120229101}

-- 添加记述卡牌列表
function RushDuel.AddCodeList(card, ...)
    for _, list in ipairs {...} do
        local type = aux.GetValueType(list)
        if type == "number" then
            aux.AddCodeList(card, list)
        elseif type == "table" then
            aux.AddCodeList(card, table.unpack(list))
        end
    end
end

-- 条件: 是否为传说卡
function RushDuel.IsLegendCode(card, ...)
    for _, list in ipairs {...} do
        local type = aux.GetValueType(list)
        if type == "number" and card:GetOriginalCode() == list and card:IsCode(120000000) then
            return true
        elseif type == "table" and RushDuel.IsLegendCode(card, table.unpack(list)) then
            return true
        end
    end
    return false
end

-- 条件: 是否为同名卡
function RushDuel.IsSameCode(card1, card2)
    if (card1:IsCode(120000000) or card2:IsCode(120000000)) then
        return card1:GetOriginalCode() == card2:GetOriginalCode()
    else
        return card1:IsCode(card2:GetCode())
    end
end
