/** 防抖函数 -> 立即执行
 * @param {function} func 操作函数
 * @param {number} delay 延迟
 * @returns
 */
export function debounceImmediate(func, delay) {
  let timeout;
  return function () {
    const immediate = !timeout;

    if (timeout) {
      clearTimeout(timeout);
    }

    timeout = setTimeout(() => {
      // func.apply(this, arguments);
      timeout = null;
    }, delay);

    if (immediate) {
      func.apply(this, arguments);
    }
  };
}