# 通用篇

## 如何进入控制台：

点击 F12，切换到【控制台】标签页即可。

## 角色 ID

在控制台里列出角色列表  
`$dataActors`
（按一下三角形就可以展开查看详细数值了）

## 道具 ID

在控制台里列出道具列表  
`$dataItems`
在控制台里列出武器列表  
`$dataWeapons`
在控制台里列出防具列表  
`$dataArmors`

## 变量和开关

在控制台里列出变量列表  
 `$gameVariables`
在控制台里列出开关列表  
 `$gameSwitches`
查看开关的作用  
 `$dataSystem.switches`
查看变量的作用  
 `$dataSystem.variables`
调整开关状态  
 `$gameSwitches.setValue(开关ID,true/false);`
调整变量状态  
 `$gameVariables.setValue(变量ID,值);`

## 查看公共事件 ID

`$dataCommonEvents`

## 执行公共事件

`$gameTemp.reserveCommonEvent(公共事件ID);`

## 地图 ID

在控制台里列出地图列表  
 `$dataMapInfos`

# 队伍篇

## 强行从队伍中移除成员

`$gameParty.removeActor(角色ID);`

## 强行在队伍中增加成员

`$gameParty.addActor(角色ID);`

# 数值篇

## 增加金钱

`$gameParty.gainGold(想要增加的数值);`
或  
 `$gameParty._gold += 想要增加的数值;（较为危险，但可以超出上限）`

## 增加经验值

`$gameActors.actor(角色ID).gainExp(想要增加的数值);`

## 增加当前 HP

`$gameActors.actor(角色ID).gainHp(想要增加的数值);`

## 增加当前 MP

`$gameActors.actor(角色ID).gainMp(想要增加的数值);`

## 增加当前 TP

`$gameActors.actor(角色ID).gainTp(想要增加的数值);`

## 永久增加额外能力值

角色最终能力 = 基础值 + 等级 \* 每级增加值 + 额外能力值。  
只有额外能力值能永久修改（其他的参数刷新页面就还原了）。  
先用  
 `$gameActors.actor(角色ID)._paramPlus;`
查看属性总长度，记下长度
比如提示(8) [0, 0, 0, 0, 0, 0, 0, 0]  
 前面的括号 8 是长度，修改时不要输入。  
 修改时  
 `$gameActors.actor(角色ID)._paramPlus = 新属性列表;`
比如上述例子就可以写  
 `$gameActors.actor(角色ID)._paramPlus = [9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999];`
其中每段对应一种属性，比如可能是[最大 HP,最大 MP,物攻,物防,魔攻,魔防,敏捷,幸运]。  
 不过哪段对应什么属性大概只能靠猜了。  
 可以是负数，不过最好别带小数点。

# 物品篇

## 获得物品

`$gameParty.gainItem($dataItems[物品ID], 个数);`

`$gameParty.gainItem($dataWeapons[武器ID], 个数);`

`$gameParty.gainItem($dataArmors[防具ID], 个数);`

# 系统篇

## 得到当前状态的存档数据

（复制出来的时候，务必记得去掉开头结尾的单引号）  
（最终手段，在卡死时只有这个能用。可配合导入导出页面，进行强行存档）  
 `LZString.compressToBase64(JsonEx.stringify(DataManager.makeSaveContents()));`

## 强行解除存档限制

`$gameSystem._saveEnabled = true;`

## 立刻进入存档画面

`SceneManager.push(Scene_Save);`

## 立刻进入读档画面

`SceneManager.push(Scene_Load);`

## 进入 Debug 画面（用于设置剧情变量、解锁 CG 等）

`SceneManager.push(Scene_Debug);`

# 角色篇

## 设置移动速度

`$gamePlayer._moveSpeed = 移动速度（可以带小数）;`

## 设置 X 坐标

`$gamePlayer._x = X坐标;`

## 设置 Y 坐标 µ

`$gamePlayer._y = Y坐标;`

## 传送到某个地图

`$gamePlayer.reserveTransfer(地图ID,X坐标,Y坐标,0,0);`

## 穿墙-切换开启关闭

`$gamePlayer._through = !$gamePlayer._through;`

## 遇敌-切换开启关闭

`$gameSystem._encounterEnabled = !$gameSystem._encounterEnabled;`

## 设置地雷式遇敌间隔的步数（重启游戏前都有效）

`Game_Player.prototype.makeEncounterCount = function() { return 步数; }`
