import { defineConfig } from 'vite';
import { svelte } from '@sveltejs/vite-plugin-svelte';

import SetEnvByCommandArg, { getCommandArgv } from 'vite-plugin-env-command';


// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    svelte(),
    SetEnvByCommandArg({
      key: "APP_ENV",
    }),
  ],
  server: {
    proxy: {
      "/api/": {
        target: "http://192.168.31.103:25702",
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api/, ""),
      },
    },
  },
});
