import { defineConfig } from 'vite';
import { svelte } from '@sveltejs/vite-plugin-svelte';

import SetEnvByCommandArg, { getCommandArgv } from 'vite-plugin-env-command';


// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    svelte(),
    SetEnvByCommandArg({
      key: "APP_ENV",
    }),
  ],
  // 代理服务器, 开发用, 将 target 改为你的浏览器内能访问到 rrpg.duels.link 的链接
  server: {
    proxy: {
      "/api/": {
        target: "http://rrpg.duels.link",
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api/, ""),
      },
    },
    // 局域网中暴露, 方便手机测试
    host: '0.0.0.0'
  },
});
