# rrpg.link 前端 [项目地址](https://code.mycard.moe/Kesa/rrpglink_frontend)

本项目为 rrpg.link 打造, 为更好展示已收藏的 RPGMaker 游戏而建.

<details>
<summary>私有git账号信息</summary>

```
url: https://code.mycard.moe/profile/keys
account: Kesa
password: kesaubeeire
```

</details>

## 技术栈

Svelte + daysiUI

## 开发

```bash
# 安装
npm install

# 在 dev 模式下开发要在 vite.config.js 中
# 把 server -> proxy -> /api/ 中的 target
# 改为你能在本地浏览器访问到的 rrpg.duels.link 的网址
# 毕竟我是开了 NGINX 转发开发的, 比较迂回

# 这是 dev 模式开发
npm run dev:dev

# 这是 prod 模式开发
npm run dev:prod
```

## 打包注意事项

使用了 [vite-plugin-env-command](https://www.npmjs.com/package/vite-plugin-env-command) 进行打包简化

```bash
# 这是 prod 模式打包
npm run build:prod
```

## 项目需求

- [x] 刮削游戏 (后端部分)
- [ ] TODO: 记忆相关
  - [ ] 历史玩过的游戏
  - [ ] 收藏的游戏
- [ ] TODO: 配置面板
  - [ ] 卡片相关
  - [ ] page 相关 (num & size)
- [ ] TODO: 更新数据 (TAG Category 游戏)
  - [ ] 主动更新按钮
  - [ ] 定时更新
- [ ] 卡片展示
  - [x] 请求 php
  - [x] 展示基础卡片
    - [x] 图片
    - [ ] TODO: 点击 Cover 预览所有图片
    - [ ] TODO: 懒加载
    - [x] 语言
  - [x] TAG
    - [x] 展示
    - [x] 汉化
- [x] 搜索
  - [x] Tag
  - [x] Category
  - [x] Title
  - [x] 导航栏 Drawer -> 分类搜索 & Tag 搜索
  - [x] 侧边栏 Drawer -> 分类搜索 & Tag 搜索
  - [ ] TODO: 回退上一级搜索
- [x] 主题切换
  - [x] 基础切换
  - [x] localstorage 记忆
- [ ] Toast 系统
  - [x] 基本 Toast
  - [x] 图片加载错误: 寻找 info.json 的图片并加载第一个, 顺表 log 显示详情

## Bugs

- [x] 导航栏 Button 连续点击容易失败 -> 样式嵌套问题, 已解决
