import { writable } from 'svelte/store';

// ----------------------------------------------------------------
// localstorage 持久化处理 -------------------------------------
/**localstorage 里存储字段对象的 key 名称*/
const persistName = 'Kesa:rrpg_link';

/** localstorage 数据持久化 svelte stores 函数
 * @param {*} key 在 localstorage 存储对象里的 key 值
 * @param {*} startValue 初始化默认值
 * @returns svelte stores 对象
 */
function persistStore(key, startValue) {
  // 判断 localstorage 中有无存储字段对象
  if (!localStorage.getItem(persistName)) localStorage.setItem(persistName, "{}");

  // 有 ls 中的值就挂载, 没有就从默认值创建, 并根据值注册 svelte store 初始化对象
  const savedValue = JSON.parse(localStorage.getItem(persistName))[key];
  const initialValue = savedValue ?? startValue;
  const store = writable(initialValue);

  // 对 svelte store 对象进行订阅以取得全局变化调用
  store.subscribe(value => {
    const data = JSON.parse(localStorage.getItem(persistName)) ?? {};
    data[key] = value;
    localStorage.setItem(persistName, JSON.stringify(data));
  });

  // FIXME: 对旧版本词条的处理, 过几个月也许可以去掉这个玩意儿, 减少损害其他东西的可能性
  if (localStorage.getItem(key)) localStorage.removeItem(key)

  return store;
}

// 变量 -------------------------------------
/** 主题 */
export const _theme = persistStore('_theme', "light");

/** 环境变量 */
export const _env = persistStore('_env', "");

/** 定时持久化: 分类 */
export const _category = persistStore('_category', {});

/** 定时持久化: TAG 翻译 */
export const _tagTrans = persistStore('_tagTrans', {});