# rrpg.link 前端 [项目地址](https://code.mycard.moe/Kesa/rrpglink_frontend)

本项目为 rrpg.link 打造, 为更好展示已收藏的 RPGMaker 游戏而建.

<details>
<summary>私有git账号信息</summary>

```
url: https://code.mycard.moe/profile/keys
account: Kesa
password: kesaubeeire
```

</details>

## 技术栈

Svelte + daysiUI

## 开发

```JavaScript
// 在 dev 模式下开发要在根目录(vite.config.js 同级目录)中
// 新建 devServer.config.js
// 改进下面的代码并复制粘贴到这个文件里
// 这个文件子在 .gitignore 中被忽略
// 可以在这里复制名称再新建文件, 不要忘记这步, 非常关键
// 单独提出来的目的是不让开发受这个代理服务器路径变更的影响

export const proxy = "http://192.168.31.103:25702";
```

```bash
# 安装
npm install

# 这是 dev 模式开发
npm run dev:dev

# 这是 prod 模式开发
npm run dev:prod
```

## 打包注意事项

使用了 [vite-plugin-env-command](https://www.npmjs.com/package/vite-plugin-env-command) 进行打包简化

```bash
# 这是 prod 模式打包
npm run build:prod
```

## 项目需求

- [x] 刮削游戏 (后端部分)
- [ ] TODO: 显示攻略
  - [ ] 显示攻略的按钮
  - [ ] 按下后弹出类似图片墙的页中小窗口，显示该游戏的攻略
  - [ ] 让玩家能一键复制指定部分的代码（已更新【甜蜜色情生活ｰ我和 2 位姐姐ｰ】的攻略文本，可用于调试）
- [ ] TODO: 记忆相关
  - [ ] 历史玩过的游戏
  - [ ] 收藏的游戏
  - [ ] 允许玩家给游戏写（本地可见的）备注，显示在标签上方，日文名下方
- [ ] TODO: 配置面板
  - [ ] 卡片相关
  - [ ] page 相关 (num & size)
  - [ ] TODO: 更新数据 (TAG Category 游戏)
    - [ ] 主动更新按钮
    - [ ] 定时更新
- [ ] TODO: 重构云存档系统
  - [ ] 统一界面风格
  - [ ] 既有功能的继承
  - [ ] 对 RMMZ 游戏（indexedDB）的处理（？）
- [ ] TODO: 重构[通用作弊代码页](http://rrpg.duels.link/cheats.html)
  - [ ] 统一界面风格
- [ ] 卡片展示
  - [x] 请求 php
    - [x] 瀑布流
  - [x] 展示基础卡片
    - [x] 图片
    - [x] 点击 Cover 预览所有图片
    - [x]  懒加载 -> 有瀑布流后大概可以不需要懒加载了？
    - [x]  图片高度统一
    - [x] 语言
  - [x] TAG
    - [x] 展示
    - [x] 汉化
- [x] 搜索
  - [x] Tag
  - [x] Category
  - [x] Title
  - [x] 导航栏 Drawer -> 分类搜索 & Tag 搜索
  - [x] 侧边栏 Drawer -> 分类搜索 & Tag 搜索
  - [ ] TODO: 回退上一级搜索
- [x] 主题切换
  - [x] 基础切换
  - [x] localstorage 记忆
- [ ] Toast 系统
  - [x] 基本 Toast
  - [x] 图片加载错误: 寻找 info.json 的图片并加载第一个, 顺表 log 显示详情

## Bugs

- [x] 导航栏 Button 连续点击容易失败 -> 样式嵌套问题, 已解决
- [x] 补充整齐功能区按钮的 tips -> 右上角的数个按钮中，只有【分类】【主题】鼠标移上去未变化样式
- [ ] 打开图片墙会改变地址栏，看起来还蛮怪的
- [ ] 先输入搜索文字，再切换分类或 tag，要搜索的文字会被无视
