#include <sourcemod>
#include <sdktools>

#pragma semicolon 1
#pragma newdecls required

public Plugin myinfo = {
    name        = "Money for survivors in CSGO",
    author      = "JoyJ",
    description = "Give money to survivors every several seconds. Killer gets the money.",
    version     = "0.0.1",
    url         = ""
};

int money_offset;
Handle timer;
ConVar itvConv;
ConVar enableConv;
ConVar itvMoneyConv;
ConVar killerRate;
ConVar assistRate;
ConVar headshotRate;
int currentRoundMoney[128];

public void OnPluginStart()
{
    itvConv = CreateConVar("sm_mfs_interval", "5.0", "MFS Version", FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY, true, 0.1);
    enableConv = CreateConVar("sm_mfs_enable", "1", "Enables/Disables the TeamMoney plugin", 0, true, 0.0, true, 1.0);
    itvMoneyConv = CreateConVar("sm_mfs_interval_money", "100", "Give money every interval", 0, true, 0.0);
    killerRate = CreateConVar("sm_mfs_killer_rate", "50", "When a player deaths, how much money should the killer get", 0, true, 0.0, true, 100.0);
    assistRate = CreateConVar("sm_mfs_assister_rate", "25", "When a player deaths, how much money should the assisster get from the killer rate", 0, true, 0.0, true, 100.0);
    headshotRate = CreateConVar("sm_mfs_headshot_rate", "200", "How much a headshot will boost the killer rate", 0, true, 100.0);
    float interval = GetConVarFloat(itvConv);
    money_offset = FindSendPropInfo("CCSPlayer", "m_iAccount");
    timer = CreateTimer(interval, TimerFunc, _, TIMER_REPEAT);
    HookEvent("round_start", ResetTimer);
    HookEvent("player_death", PlayerDeathFunc);
}

public Action PlayerDeathFunc(Event event, const char[] name, bool dontBroadcast)
{
    int killer=GetClientOfUserId(GetEventInt(event,"attacker"));
    int victim=GetClientOfUserId(GetEventInt(event,"userid"));
    int assister=GetClientOfUserId(GetEventInt(event,"assister"));
    bool headshot=GetEventBool(event,"headshot");
    int kRate = GetConVarInt(killerRate);
    int aRate = GetConVarInt(assistRate);
    if (headshot)
    {
        kRate = kRate * GetConVarInt(headshotRate) / 100;
    }
    int kMoney = currentRoundMoney[victim] * kRate / 100;
    if (killer==0 || victim==0 || killer==victim)
    {
        return Plugin_Continue;
    }
    kMoney = -AddMoney(victim, -kMoney);
    if (kMoney == 0)
    {
        return Plugin_Continue;
    }
    int aMoney = kMoney * aRate / 100;
    if (assister>0)
    {
        kMoney -= aMoney;
        AddMoney(assister, aMoney);
        PrintCenterText(assister,"你获得了 %i 的助攻金钱",kMoney);
    }
    AddMoney(killer, kMoney);
    PrintCenterText(killer,"你获得了 %i 的击杀金钱",kMoney);
    return Plugin_Continue;
}

public Action ResetTimer(Event event, const char[] name, bool dontBroadcast)
{
    for(int i=1;i<=MaxClients;i++)
    {
        currentRoundMoney[i]=0;
    }
    KillTimer(timer);
    float interval = GetConVarFloat(itvConv);
    timer = CreateTimer(interval, TimerFunc, _, TIMER_REPEAT);
    return Plugin_Continue;
}

public Action TimerFunc(Handle tm)
{
    bool nowEnable = GetConVarBool(enableConv);
    int add = GetConVarInt(itvMoneyConv);
    if (!nowEnable)
    {
        return Plugin_Continue;
    }
    for ( int i = 1; i <= MaxClients; ++i )
    {
        if (IsPlayerAlive(i))
        {
            currentRoundMoney[i] += AddMoney(i,add);
        }
    }
    return Plugin_Continue;
}

public int AddMoney(int i,int money)
{
    if (!IsClientInGame(i) || IsClientObserver(i) || i>MaxClients || i<=0)
    {
        return 0;
    }
    int orig_money = GetEntData(i, money_offset, 2);
    int new_money = orig_money + money;
    if (new_money>65535)
    {
        new_money=65535;
    }
    if(new_money<0)
    {
        new_money=0;
    }
    SetEntData(i, money_offset, new_money);
    return new_money - orig_money;
}