
if not _GENKAITOPPA then
	_GENKAITOPPA = {}
	_GENKAITOPPA.CloudianFilter = function(c)
		return c:IsAbleToHand() and c:IsSetCard(0x18)
	end
	_GENKAITOPPA.CloudianTarget = function(e,tp,eg,ep,ev,re,r,rp,chk)
		local c = e:GetHandler()
		if chk==0 then return Duel.GetMZoneCount(tp) > 0 and
			c:IsCanBeSpecialSummoned(e,0,tp,false,false)
			and Duel.IsExistingMatchingCard(_GENKAITOPPA.CloudianFilter,tp,LOCATION_DECK,0,1,nil) end
		Duel.SetOperationInfo(0,CATEGORY_SPECIAL_SUMMON,c,1,0,0)
		Duel.SetOperationInfo(0,CATEGORY_TOHAND,nil,1,tp,LOCATION_DECK)
	end
	_GENKAITOPPA.CloudianOperation = function(e,tp,eg,ep,ev,re,r,rp)
		local c = e:GetHandler()
		if c:IsRelateToEffect(e) and Duel.GetMZoneCount(tp) > 0
			and Duel.SpecialSummonStep(c,0,tp,tp,false,false,POS_FACEUP) then
			--cannot be link material
			local e1=Effect.CreateEffect(c)
			e1:SetType(EFFECT_TYPE_SINGLE)
			e1:SetProperty(EFFECT_FLAG_CANNOT_DISABLE+EFFECT_FLAG_UNCOPYABLE)
			e1:SetCode(EFFECT_CANNOT_BE_LINK_MATERIAL)
			e1:SetReset(RESET_EVENT+RESETS_STANDARD)
			e1:SetValue(1)
			c:RegisterEffect(e1)
			Duel.SpecialSummonComplete()
			Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_ATOHAND)
			local g = Duel.SelectMatchingCard(tp,_GENKAITOPPA.CloudianFilter,tp,LOCATION_DECK,0,1,1,nil)
			if g and #g > 0 and Duel.SendtoHand(g,nil,REASON_EFFECT) then
				Duel.BreakEffect()
				local g2=Duel.GetMatchingGroup(Card.IsCanAddCounter,tp,LOCATION_MZONE,0,nil,0x1019,1)
				local tc=g2:GetFirst()
				while tc do
					tc:AddCounter(0x1019,1)
					tc=g2:GetNext()
				end
			end
		end
	end
	_GENKAITOPPA.CloudianRegister = function(c)
		local code = c:GetOriginalCode()
		--spsummon
		local e1=Effect.CreateEffect(c)
		e1:SetDescription(aux.Stringid(16197610,1))
		e1:SetType(EFFECT_TYPE_IGNITION)
		e1:SetCategory(CATEGORY_SPECIAL_SUMMON+CATEGORY_SEARCH+CATEGORY_TOHAND+CATEGORY_COUNTER)
		e1:SetRange(LOCATION_HAND)
		e1:SetCountLimit(1,code)
		e1:SetTarget(_GENKAITOPPA.CloudianTarget)
		e1:SetOperation(_GENKAITOPPA.CloudianOperation)
		c:RegisterEffect(e1)
	end
	function _GENKAITOPPA.FortuneLadySpecialSummonLimit(e,c,tp,sumtp,sumpos)
		return not c:IsSetCard(0x162) and (bit.band(sumtp,SUMMON_TYPE_SYNCHRO)==SUMMON_TYPE_SYNCHRO)
	end
	_GENKAITOPPA.FortuneLadySpecialSummonCost = function(e,tp,eg,ep,ev,re,r,rp,chk)
		if chk == 0 then return true end
		local e1=Effect.CreateEffect(e:GetHandler())
		e1:SetType(EFFECT_TYPE_FIELD)
		e1:SetCode(EFFECT_CANNOT_SPECIAL_SUMMON)
		e1:SetProperty(EFFECT_FLAG_PLAYER_TARGET+EFFECT_FLAG_OATH)
		e1:SetTargetRange(1,0)
		e1:SetTarget(_GENKAITOPPA.FortuneLadySpecialSummonLimit)
		e1:SetReset(RESET_PHASE+PHASE_END)
		--Duel.RegisterEffect(e1,tp)
	end
	_GENKAITOPPA.FortuneLadySpecialSummonTarget = function(e,tp,eg,ep,ev,re,r,rp,chk)
		local c = e:GetHandler()
		if chk == 0 then return Duel.GetMZoneCount(tp) > 0
			and c:IsCanBeSpecialSummoned(e,0,tp,false,false) end
		Duel.SetOperationInfo(0,CATEGORY_SPECIAL_SUMMON,c,1,tp,0)
	end
	_GENKAITOPPA.FortuneLadySpecialSummonFilter = function(c)
		return c:IsFaceup() and c:IsSetCard(0x31)
	end
	_GENKAITOPPA.FortuneLadySpecialSummonOperation = function(e,tp,eg,ep,ev,re,r,rp)
		local c = e:GetHandler()
		if not c:IsRelateToEffect(e) then return end
		if Duel.SpecialSummon(c,0,tp,tp,false,false,POS_FACEUP) > 0 and Duel.SelectYesNo(tp,aux.Stringid(71870152,0)) then
			Duel.BreakEffect()
			Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_TARGET)
			local g = Duel.SelectMatchingCard(tp,_GENKAITOPPA.FortuneLadySpecialSummonFilter,tp,LOCATION_MZONE,0,1,1,nil)
			if g and #g > 0 then
				c = g:GetFirst()
				local e1=Effect.CreateEffect(c)
				e1:SetType(EFFECT_TYPE_SINGLE)
				e1:SetCode(EFFECT_UPDATE_LEVEL)
				e1:SetValue(3)
				e1:SetReset(RESET_EVENT+RESETS_STANDARD)
				c:RegisterEffect(e1)
			end
		end
	end
	_GENKAITOPPA.FortuneLadyRegister = function(c,alt_code)
		local code = c:GetOriginalCode()
		--spsummon
		local e2=Effect.CreateEffect(c)
		e2:SetDescription(aux.Stringid(70252926,1))
		e2:SetCategory(CATEGORY_SPECIAL_SUMMON)
		e2:SetType(EFFECT_TYPE_SINGLE+EFFECT_TYPE_TRIGGER_O)
		e2:SetCode(EVENT_REMOVE)
		e2:SetProperty(EFFECT_FLAG_DELAY)
		e2:SetCountLimit(1,alt_code or code)
		e2:SetCost(_GENKAITOPPA.FortuneLadySpecialSummonCost)
		e2:SetTarget(_GENKAITOPPA.FortuneLadySpecialSummonTarget)
		e2:SetOperation(_GENKAITOPPA.FortuneLadySpecialSummonOperation)
		c:RegisterEffect(e2)
		local e3=e2:Clone()
		e3:SetCode(EVENT_TO_GRAVE)
		c:RegisterEffect(e3)
	end
	_GENKAITOPPA.SolfachordSpecialSummonFilter = function(c)
		return c:IsSetCard(0x162) and c:IsAbleToHand()
	end
	function _GENKAITOPPA.SolfachordSearchSpecialSummonLimit(e,c)
		return not c:IsSetCard(0x162) and (not c:IsLocation(LOCATION_EXTRA))
	end
	_GENKAITOPPA.SolfachordSearchCost = function(e,tp,eg,ep,ev,re,r,rp,chk)
		if chk == 0 then return true end
		local e1=Effect.CreateEffect(e:GetHandler())
		e1:SetType(EFFECT_TYPE_FIELD)
		e1:SetCode(EFFECT_CANNOT_SPECIAL_SUMMON)
		e1:SetProperty(EFFECT_FLAG_PLAYER_TARGET+EFFECT_FLAG_OATH)
		e1:SetTargetRange(1,0)
		e1:SetTarget(_GENKAITOPPA.SolfachordSearchSpecialSummonLimit)
		e1:SetReset(RESET_PHASE+PHASE_END)
		Duel.RegisterEffect(e1,tp)
	end
	_GENKAITOPPA.SolfachordSearchTarget = function(e,tp,eg,ep,ev,re,r,rp,chk)
		local c = e:GetHandler()
		if chk==0 then return Duel.IsExistingMatchingCard(_GENKAITOPPA.SolfachordSpecialSummonFilter,tp,LOCATION_DECK,0,1,nil)
			and c:IsAbleToHand() end
		Duel.SetOperationInfo(0,CATEGORY_TOHAND,nil,1,tp,LOCATION_DECK+LOCATION_PZONE)
	end
	_GENKAITOPPA.SolfachordSearchOperation = function(e,tp,eg,ep,ev,re,r,rp)
		local c = e:GetHandler()
		if not c:IsRelateToEffect(e) then return end
		local g = Duel.SelectMatchingCard(tp,_GENKAITOPPA.SolfachordSpecialSummonFilter,tp,LOCATION_DECK,0,1,1,nil)
		if g and #g > 0 and Duel.SendtoHand(g,nil,REASON_EFFECT) > 0 then
			Duel.SendtoHand(c,nil,REASON_EFFECT)
		end
	end
	_GENKAITOPPA.SolfachordAtkChangeTarget = function(e,tp,eg,ep,ev,re,r,rp,chk)
		local c = e:GetHandler()
		if chk == 0 then return Duel.GetFieldGroup(tp,LOCATION_PZONE,0):GetCount() > 0 end
	end
	_GENKAITOPPA.SolfachordAtkChangeOperation = function(e,tp,eg,ep,ev,re,r,rp)
		local c = e:GetHandler()
		if not c:IsRelateToEffect(e) then return end
		local e1=Effect.CreateEffect(c)
		e1:SetType(EFFECT_TYPE_SINGLE)
		e1:SetCode(EFFECT_SET_ATTACK_FINAL)
		e1:SetReset(RESET_EVENT+RESETS_STANDARD+RESET_PHASE+PHASE_END)
		local atk = c:GetAttack()*2
		if atk < 2000 then atk = 2000 end
		e1:SetValue(atk)
		c:RegisterEffect(e1)
		Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_TARGET)
		local g = Duel.SelectMatchingCard(tp,nil,tp,LOCATION_PZONE,0,1,1,nil)
		if g and #g > 0 then
			local option = Duel.SelectOption(tp,aux.Stringid(26420373,1),aux.Stringid(26420373,2))
			local add = 1
			if option == 1 then add = -1 end
			local e1=Effect.CreateEffect(c)
			e1:SetType(EFFECT_TYPE_SINGLE)
			e1:SetCode(EFFECT_UPDATE_LSCALE)
			e1:SetReset(RESET_EVENT+RESETS_STANDARD)
			e1:SetValue(add)
			g:GetFirst():RegisterEffect(e1)
			local e2=e1:Clone()
			e2:SetCode(EFFECT_UPDATE_RSCALE)
			g:GetFirst():RegisterEffect(e2)
		end
	end
	_GENKAITOPPA.SolfachordRegister = function(c, alt_code)
		local code = c:GetOriginalCode()
		--to hand
		local e1=Effect.CreateEffect(c)
		e1:SetDescription(aux.Stringid(123709,1))
		e1:SetCategory(CATEGORY_TOHAND)
		e1:SetType(EFFECT_TYPE_IGNITION)
		e1:SetRange(LOCATION_PZONE)
		e1:SetCountLimit(1,alt_code or code)
		e1:SetCost(_GENKAITOPPA.SolfachordSearchCost)
		e1:SetTarget(_GENKAITOPPA.SolfachordSearchTarget)
		e1:SetOperation(_GENKAITOPPA.SolfachordSearchOperation)
		c:RegisterEffect(e1)
		--atkchange
		local e2=Effect.CreateEffect(c)
		e2:SetDescription(aux.Stringid(26420373,0))
		e2:SetCategory(CATEGORY_ATKCHANGE)
		e2:SetType(EFFECT_TYPE_QUICK_O)
		e2:SetCode(EVENT_FREE_CHAIN)
		e2:SetRange(LOCATION_MZONE)
		e2:SetCountLimit(1)
		e2:SetTarget(_GENKAITOPPA.SolfachordAtkChangeTarget)
		e2:SetOperation(_GENKAITOPPA.SolfachordAtkChangeOperation)
		c:RegisterEffect(e2)
	end
end
