---------------------------------------------------------------------------
--- The Creation Come From: A Beginner AI 
--- Author: 决明子 Email: dota2jmz@163.com 微博@Dota2_决明子
--- Link:http://steamcommunity.com/sharedfiles/filedetails/?id=1573671599
--- Link:http://steamcommunity.com/sharedfiles/filedetails/?id=1627071163
---------------------------------------------------------------------------
if not GetBot():IsHero() or not string.find(GetBot():GetUnitName(), "hero") or GetBot():IsIllusion() then
	return
end

local X = {}

require(GetScriptDirectory() .. "/rewrite_functions")
local J = require( GetScriptDirectory()..'/FunLib/jmz_func')
local bot = GetBot()

function GetTeamLaneTowerStatus(...)
    local args = {...}
    local result = 1
    for _,tower in pairs(args) do
        local unit=GetTower(GetTeam(),tower)
        if not unit or not unit:IsAlive() then
            result = result + 1
        else
            return result
        end
    end
    return result
end

function GetEnemyLaneTowerStatus(...)
    local args = {...}
    local result = 1
    for _,tower in pairs(args) do
        local unit=GetTower(GetOpposingTeam(),tower)
        if not unit or not unit:IsAlive() then
            result = result + 1
        else
            return result
        end
    end
    return result
end

function GetFirstAliveTower(...)
    local args = {...}
    for _,tower in pairs(args) do
        local unit=GetTower(GetTeam(),tower)
        if unit and unit:IsAlive() then
            return unit
        end
    end
    return nil
end

function GetDesire()

	local now = DotaTime()
	local lv = bot:GetLevel()
    local isCurrentLine = bot:GetAssignedLane() == LANE_TOP

	local allyKills  = J.GetNumOfTeamTotalKillsWithoutHuman(false);
	local enemyKills = J.GetNumOfTeamTotalKills(true);
    local front = GetLaneFrontAmount(GetTeam(), LANE_TOP, false)
    local front_other = math.min(GetLaneFrontAmount(GetTeam(), LANE_MID, false), GetLaneFrontAmount(GetTeam(), LANE_BOT, false))

    --当前Bot经济在己方阵营的排名。1为第一名，2为第二名，以此类推。
    local worthRank = 1

    local allies = GetUnitList(UNIT_LIST_ALLIED_HEROES)
    allies = FilterTable(allies,function(u)
        return not u:IsIllusion() and u:IsAlive()
    end)

    local team={}
    team[bot:GetPlayerID()] = true
  
    for ally in pairs(allies) do
        if not ally:IsIllusion() and ally:GetNetWorth() > bot and not team[ally:GetPlayerID()] then
            team[ally:GetPlayerID()] = true
            worthRank = worthRank + 1
        end
    end

	local aliveEnemyCount = J.GetNumOfAliveHeroes(true);
	local aliveAllyCount  = #allies;

    local tower_top = GetEnemyLaneTowerStatus(TOWER_TOP_1,TOWER_TOP_2,TOWER_TOP_3,BARRACKS_TOP_MELEE)
    local tower_mid = GetEnemyLaneTowerStatus(TOWER_MID_1,TOWER_MID_2,TOWER_MID_3,BARRACKS_MID_MELEE)
    local tower_bot = GetEnemyLaneTowerStatus(TOWER_BOT_1,TOWER_TOP_2,TOWER_BOT_3,BARRACKS_BOT_MELEE)

    --前线位置
    local front_loc = GetLaneFrontLocation(GetTeam(), LANE_TOP, 0)

    --前线友军小兵数量
    local front_ally_creeps_num = GetUnitList(UNIT_LIST_ALLIED_CREEPS)
    front_ally_creeps_num = #(FilterTable(front_ally_creeps_num,function(u)
        return u:IsAlive() and u:GetDistanceToLocation(front_loc) < 1200
    end))

    --前线敌军小兵数量
    local front_enemy_creeps_num = GetUnitList(UNIT_LIST_ENEMY_CREEPS)
    front_enemy_creeps_num = #(FilterTable(front_enemy_creeps_num,function(u)
        return u:IsAlive() and u:GetDistanceToLocation(front_loc) < 1200
    end))

    --前线敌军英雄数量
    local front_enemy_hero_num = 0
    local enemyTeam = GetTeamPlayers(GetOpposingTeam())

    for _,player in pairs(enemyTeam) do
        local info = GetHeroLastSeenInfo(player)
        if info ~= nil then
            local dInfo = info[1]
            if dInfo ~= nil and dInfo.time_since_seen and dInfo.time_since_seen < 10.0
                and J.GetDistanceFromVectorToVector(front_loc,dInfo.location) < 1000 
            then
                front_enemy_hero_num = front_enemy_hero_num + 1;
            end
        end
    end

    local enemyCount = 0
    for i = 1, #enemyTeam do
        local info = GetHeroLastSeenInfo(enemyTeam[i])
        if info ~= nil then
            local dInfo = info[1]
            if dInfo ~= nil and dInfo.time_since_seen and dInfo.time_since_seen < 30.0
                and  GetUnitToLocationDistance(bot,dInfo.location) < 1000 
            then
                front_enemy_hero_num = enemyCount +1;
            end
        end	
    end

    front_enemy_hero_num = enemyCount


    --前线友军英雄数量

    local self_tower_top = GetTeamLaneTowerStatus(TOWER_TOP_1,TOWER_TOP_2,TOWER_TOP_3,BARRACKS_TOP_MELEE)

    --自己最前方的塔
    local front_tower = GetFirstAliveTower(TOWER_TOP_1,TOWER_TOP_2,TOWER_TOP_3,BARRACKS_TOP_MELEE)

    --对方上路已破路且自己没破路，则除非被推到家门口，否则完全不去管理
    --让最穷的人去守，剩下的人该干啥干啥
    if tower_top == 5 and front_tower then
        if front < 0.2 and front > front_other and worthRank==#team then
            return BOT_ACTION_DESIRE_MODERATE * (0.2 - front) * 5
        end
        return BOT_ACTION_DESIRE_NONE
    end

    --出兵前，推个锤子
	if now <= 10 then
		return BOT_ACTION_DESIRE_NONE
	end
	
    --7级之前的情况。基本上可以认为不换路。
	if lv <= 7 then
        if isCurrentLine then
		    return BOT_ACTION_DESIRE_MODERATE
        else
            return BOT_ACTION_DESIRE_NONE
        end
	end

    if lv <= 12 then
        local base = 0.1
        if tower_top > tower_mid and tower_top > tower_bot then
            base = base + 0.4
        elseif tower_top > tower_mid or tower_top > tower_bot then
            base = base + 0.2
        end
        if isCurrentLine then
            base = base + 0.4
        end
        return base
    end
    
    local farm = bot:GetFarmWorth()
    if J.IsFarmer(bot) then
        farm = 10000
    end
    if J.IsHighFarmer(bot) then
        farm = 15000
    end
    if J.IsVeryHighFarmer(bot) then
        farm = 20000
    end

    local desire = 0.1

    --如果最基本的装备不足，则以猥琐打钱和防守为主
    if bot:GetNetWorth() < farm then
        if isCurrentLine then
            desire = desire + 0.4
        end
    end

    --大推进时间！凑够基本装备以后就可以开始抱团推进了


    if tower_top > tower_mid and tower_top > tower_bot then
        desire = desire + 0.4
    elseif tower_top > tower_mid or tower_top > tower_bot then
        desire = desire + 0.2
    end
    desire = desire - aliveEnemyCount * 0.05
    

	return BOT_ACTION_DESIRE_NONE

end

-- dota2jmz@163.com QQ:2462331592..
