local X = {}
local bDebugMode = true
local bot = GetBot()

local J = require( GetScriptDirectory()..'/FunLib/jmz_func' )
local Minion = dofile( GetScriptDirectory()..'/FunLib/aba_minion' )
local sTalentList = J.Skill.GetTalentList( bot )
local sAbilityList = J.Skill.GetAbilityList( bot )
local sOutfitType = J.Item.GetOutfitType( bot )

local tTalentTreeList = {
						['t25'] = {10, 0},
						['t20'] = {10, 0},
						['t15'] = {0, 10},
						['t10'] = {10, 0},
}

local tAllAbilityBuildList = {
    {2,3,1,2,3,6,3,2,2,3,6,1,1,1,6},
}

local nAbilityBuildList = J.Skill.GetRandomBuild( tAllAbilityBuildList )

local nTalentBuildList = J.Skill.GetTalentBuild( tTalentTreeList )

local tOutFitList = {}

tOutFitList['outfit_carry'] = {

	"item_bristleback_outfit",
	"item_armlet",
	"item_desolator",
	"item_aghanims_shard",
	"item_heavens_halberd",
	"item_heart",
	"item_travel_boots",
	"item_abyssal_blade",
	"item_skadi",
	"item_moon_shard",
	"item_travel_boots_2",

}

tOutFitList['outfit_mid'] = tOutFitList['outfit_carry']

tOutFitList['outfit_priest'] = tOutFitList['outfit_carry']

tOutFitList['outfit_mage'] = tOutFitList['outfit_carry']

tOutFitList['outfit_tank'] = tOutFitList['outfit_carry']

X['sBuyList'] = tOutFitList[sOutfitType]

X['sSellList'] = {
	"item_phase_boots",
	"item_quelling_blade",

	'item_travel_boots',
	'item_armlet',

	"item_assault",
	"item_magic_wand",
	
	"item_travel_boots",
	"item_magic_wand",

	"item_assault",
	"item_ancient_janggo",
}

if J.Role.IsPvNMode() or J.Role.IsAllShadow() then X['sBuyList'], X['sSellList'] = { 'PvN_tank' }, {} end

nAbilityBuildList, nTalentBuildList, X['sBuyList'], X['sSellList'] = J.SetUserHeroInit( nAbilityBuildList, nTalentBuildList, X['sBuyList'], X['sSellList'] )

X['sSkillList'] = J.Skill.GetSkillList( sAbilityList, nAbilityBuildList, sTalentList, nTalentBuildList )

X['bDeafaultAbility'] = true
X['bDeafaultItem'] = true

function X.MinionThink( hMinionUnit )

	if Minion.IsValidUnit( hMinionUnit )
	then
		Minion.IllusionThink( hMinionUnit )
	end

end

local abilityQ = bot:GetAbilityByName( sAbilityList[1] )
local abilityD = bot:GetAbilityByName( sAbilityList[4] )
local abilityF = bot:GetAbilityByName( 'life_stealer_consume' )
local abilityR = bot:GetAbilityByName( sAbilityList[6] )

local castQDesire
local castDDesire, castDTarget
local castRDesire, castRTarget
local castFDesire

local nKeepMana, nMP, nHP, nLV, hEnemyList, hAllyList, botTarget, sMotive
local aetherRange = 0

function X.SkillsComplement()

	if J.CanNotUseAbility( bot ) or bot:IsInvisible() then return end

	nKeepMana = 150
	aetherRange = 0
	nLV = bot:GetLevel()
	nMP = bot:GetMana()/bot:GetMaxMana()
	nHP = bot:GetHealth()/bot:GetMaxHealth()
	botTarget = J.GetProperTarget( bot )
	hEnemyList = bot:GetNearbyHeroes( 1600, true, BOT_MODE_NONE )
	hAllyList = J.GetAlliesNearLoc( bot:GetLocation(), 1600 )

	
	aetherRange = J.GetBonusCastRange( bot )

    castQDesire, sMotive = X.ConsiderQ()
    if ( castQDesire > 0 ) then

        J.SetReportMotive( bDebugMode, sMotive )

        J.SetQueuePtToINT( bot, true )

        bot:ActionQueue_UseAbility( abilityQ )

        return
    end

	castDDesire, castDTarget, sMotive = X.ConsiderD()
	if ( castDDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )

		J.SetQueuePtToINT( bot, false )

		bot:ActionQueue_UseAbilityOnEntity( abilityD, castDTarget )
		return

	end

	castFDesire, sMotive = X.ConsiderF()
	if ( castFDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )
		bot:ClearActions(true)
        bot:Action_UseAbility( abilityF )
		return
	end

	castRDesire, castRTarget, sMotive = X.ConsiderR()
	if ( castRDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )

		J.SetQueuePtToINT( bot, true )

		bot:ActionQueue_UseAbilityOnEntity( abilityR, castRTarget )
		return
	end

end
function X.ConsiderQ()

	if not abilityQ:IsFullyCastable() then return BOT_ACTION_DESIRE_NONE end
	
	local nCastRange = 1300
	local sCastType = 'none'
	local hEffectTarget = nil
	local sCastMotive = nil
	local nInRangeEnmyList = bot:GetNearbyHeroes( nCastRange, true, BOT_MODE_NONE )


	if #nInRangeEnmyList > 0
		and not bot:IsMagicImmune()
		and not bot:IsInvulnerable()
		and not bot:HasModifier( 'modifier_item_lotus_orb_active' )
		and not bot:HasModifier( 'modifier_antimage_spell_shield' )
		and ( J.IsGoingOnSomeone( bot ) or J.IsRetreating( bot ) )
	then
		if bot:IsRooted() then
			sCastMotive = '解缠绕'
			return BOT_ACTION_DESIRE_HIGH, sCastMotive
		end

		if J.IsNotAttackProjectileIncoming( bot, 350 )
		then
			sCastMotive = '防御弹道'
			return BOT_ACTION_DESIRE_HIGH, sCastMotive
		end

		if J.IsWillBeCastUnitTargetSpell( bot, nCastRange )
		then
			sCastMotive = '防御指向技能'
			return BOT_ACTION_DESIRE_HIGH, sCastMotive
		end

		if J.IsWillBeCastPointSpell( bot, nCastRange )
		then
			sCastMotive = '防御地点技能'
			return BOT_ACTION_DESIRE_HIGH, sCastMotive
		end

		if J.GetEnemyCount( bot, 800 ) >= 3 or (nHP < 0.5 and bot:WasRecentlyDamagedByAnyHero(2.0))
		then
			sCastMotive = '先开BKB切入'
			return BOT_ACTION_DESIRE_HIGH, sCastMotive
		end

		if J.IsRetreating(bot) and bot:GetActiveMode()~=BOT_MODE_FARM and bot:WasRecentlyDamagedByAnyHero(2.0)
			and nHP<0.7 then
			sCastMotive = '撤退魔免'
			return BOT_ACTION_DESIRE_HIGH, sCastMotive
		end

	end

	return BOT_ACTION_DESIRE_NONE

end

function X.ConsiderF()
	if not abilityF or not abilityF:IsFullyCastable() or abilityF:IsHidden() then return BOT_ACTION_DESIRE_NONE end

	local hp= 0.5 + bot:GetNearbyHeroes( 1200, true, BOT_MODE_NONE ) * 0.2 - bot:GetNearbyHeroes( 1200, true, BOT_MODE_NONE ) * 0.1
	
	if J.GetHP(bot)<hp then return BOT_ACTION_DESIRE_NONE end
	
	return BOT_ACTION_DESIRE_HIGH

end

function X.ConsiderD()

	if not abilityD:IsFullyCastable() or abilityD:IsHidden() then return BOT_ACTION_DESIRE_NONE end

	local nCastRange = abilityD:GetCastRange()
	local nCastPoint = abilityD:GetCastPoint()
	local nSkillLV = abilityD:GetLevel()

	local nEnemysHeroesInCastRange = bot:GetNearbyHeroes( nCastRange + 99, true, BOT_MODE_NONE )
	local nEnemysHeroesInView = bot:GetNearbyHeroes( 880, true, BOT_MODE_NONE )

	--团战
	if J.IsInTeamFight( bot, 1200 )
		and DotaTime() > 4 * 60
	then
		local npcMostDangerousEnemy = nil
		local nMostDangerousDamage = 0

		for _, npcEnemy in pairs( nEnemysHeroesInCastRange )
		do
			if J.IsValid( npcEnemy )
				and J.CanCastOnNonMagicImmune( npcEnemy )
				and J.CanCastOnTargetAdvanced( npcEnemy )
				and not J.IsDisabled( npcEnemy )
				and not npcEnemy:IsDisarmed()
			then
				local npcEnemyDamage = npcEnemy:GetEstimatedDamageToTarget( false, bot, 3.0, DAMAGE_TYPE_ALL )
				if ( npcEnemyDamage > nMostDangerousDamage )
				then
					nMostDangerousDamage = npcEnemyDamage
					npcMostDangerousEnemy = npcEnemy
				end
			end
		end

		if ( npcMostDangerousEnemy ~= nil )
		then
			return BOT_ACTION_DESIRE_HIGH, npcMostDangerousEnemy
		end
	end

	--常规
	if J.IsGoingOnSomeone( bot )
	then
		local target = J.GetProperTarget( bot )
		if J.IsValidHero( target )
			and J.CanCastOnNonMagicImmune( target )
			and J.CanCastOnTargetAdvanced( target )
			and J.IsInRange( target, bot, nCastRange )
		then
			return BOT_ACTION_DESIRE_HIGH, target
		end
	end

	--对线期间

	if J.IsRetreating( bot )
	then
		if J.IsValid( nEnemysHeroesInCastRange[1] )
			and J.CanCastOnNonMagicImmune( nEnemysHeroesInCastRange[1] )
			and J.CanCastOnTargetAdvanced( nEnemysHeroesInCastRange[1] )
			and not J.IsDisabled( nEnemysHeroesInCastRange[1] )
			and not nEnemysHeroesInCastRange[1]:IsDisarmed()
			and GetUnitToUnitDistance( bot, nEnemysHeroesInCastRange[1] ) <= nCastRange - 60
		then
			return BOT_ACTION_DESIRE_HIGH, nEnemysHeroesInCastRange[1]
		end
	end

	if bot:GetActiveMode() == BOT_MODE_ROSHAN
		and bot:GetMana() > 400
	then
		local target =  bot:GetAttackTarget()

		if target ~= nil and target:IsAlive()
			and J.GetHP( target ) > 0.2
			and not J.IsDisabled( target )
			and not target:IsDisarmed()
		then
			return BOT_ACTION_DESIRE_LOW, target
		end
	end

	return BOT_ACTION_DESIRE_NONE

end

function X.ConsiderR()

	if not abilityR:IsFullyCastable() then return 0 end

	local nSkillLV = abilityR:GetLevel()
	local nCastRange = abilityR:GetCastRange() + aetherRange + 32
	local nCastPoint = abilityR:GetCastPoint()
	local nManaCost = abilityR:GetManaCost()
	local nDamage = abilityR:GetAbilityDamage()
	local nDamageType = DAMAGE_TYPE_MAGICAL

	if #hEnemyList == 0 then nCastRange = 1600 end

	local nEnemyCreepList = bot:GetNearbyCreeps( nCastRange, true )

	local nBestCreep = nil

	local targetCreepBountyGoldMax = 0
	for _, nCreep in pairs( nEnemyCreepList )
	do
		if J.IsValid( nCreep )
			and not nCreep:IsHero()
			and not nCreep:IsAncientCreep()
			and not nCreep:IsMagicImmune()
			and nCreep:GetHealth() > targetCreepBountyGoldMax
		then
			nBestCreep = nCreep
			targetCreepBountyGoldMax = nCreep:GetHealth()
		end
	end

	if nBestCreep ~= nil 
	then
		return BOT_ACTION_DESIRE_HIGH, nBestCreep, "R-吃敌方兵:"..nBestCreep:GetUnitName()
	end
	
	local nAllyCreepList = bot:GetNearbyCreeps( nCastRange, false )
	
	for _, nCreep in pairs( nAllyCreepList )
	do
		if J.IsValid( nCreep )
			and not nCreep:IsHero()
			and (not nCreep:IsAncientCreep() or nSkillLV >= 2)
			and not nCreep:IsMagicImmune()
			and nCreep:GetHealth() > targetCreepBountyGoldMax
		then
			nBestCreep = nCreep
			targetCreepBountyGoldMax = nCreep:GetHealth()
		end
	end

	if nBestCreep ~= nil 
	then
		return BOT_ACTION_DESIRE_HIGH, nBestCreep, "R-吃友方兵:"..nBestCreep:GetUnitName()
	end
	
	return BOT_ACTION_DESIRE_NONE

end

return X



