----------------------------------------------------------------------------------------------------
--- The Creation Come From: BOT EXPERIMENT Credit:FURIOUSPUPPY
--- BOT EXPERIMENT Author: Arizona Fauzie 2018.11.21
--- Link:http://steamcommunity.com/sharedfiles/filedetails/?id=837040016
--- Refactor: 决明子 Email: dota2jmz@163.com 微博@Dota2_决明子
--- Link:http://steamcommunity.com/sharedfiles/filedetails/?id=1573671599
--- Link:http://steamcommunity.com/sharedfiles/filedetails/?id=1627071163
----------------------------------------------------------------------------------------------------
local X = {}
local bDebugMode = ( 1 == 10 )
local bot = GetBot()

local J = require( GetScriptDirectory()..'/FunLib/jmz_func' )
local Minion = dofile( GetScriptDirectory()..'/FunLib/aba_minion' )
local sTalentList = J.Skill.GetTalentList( bot )
local sAbilityList = J.Skill.GetAbilityList( bot )
local sOutfitType = J.Item.GetOutfitType( bot )


local tTalentTreeList = {
						['t25'] = {10, 0},
						['t20'] = {10, 0},
						['t15'] = {0, 10},
						['t10'] = {0, 10},
}

local tAllAbilityBuildList = {
						{2,1,3,1,2,6,1,1,2,2,6,3,3,3,6},
}

local nAbilityBuildList = J.Skill.GetRandomBuild( tAllAbilityBuildList )

local nTalentBuildList = J.Skill.GetTalentBuild( tTalentTreeList )

local sRandomItem_1 = RandomInt( 1, 9 ) > 6 and "item_satanic" or "item_butterfly"

local tOutFitList = {}

tOutFitList['outfit_carry'] = {

	"item_ranged_carry_outfit",
	"item_blight_stone",
	"item_dragon_lance",
	"item_orchid",
	"item_desolator",
	"item_black_king_bar",
	"item_travel_boots",
	"item_bloodthorn",
	"item_hurricane_pike",
	sRandomItem_1,
	"item_moon_shard",
	"item_travel_boots_2",

}

tOutFitList['outfit_mid'] = tOutFitList['outfit_carry']

tOutFitList['outfit_priest'] = tOutFitList['outfit_carry']

tOutFitList['outfit_mage'] = tOutFitList['outfit_carry']

tOutFitList['outfit_tank'] = tOutFitList['outfit_carry']

X['sBuyList'] = tOutFitList[sOutfitType]


X['sSellList'] = {

	"item_bloodthorn",
	"item_magic_wand",

}

if J.Role.IsPvNMode() or J.Role.IsAllShadow() then X['sBuyList'], X['sSellList'] = { 'PvN_clinkz' }, {} end

nAbilityBuildList, nTalentBuildList, X['sBuyList'], X['sSellList'] = J.SetUserHeroInit( nAbilityBuildList, nTalentBuildList, X['sBuyList'], X['sSellList'] )

X['sSkillList'] = J.Skill.GetSkillList( sAbilityList, nAbilityBuildList, sTalentList, nTalentBuildList )

X['bDeafaultAbility'] = false
X['bDeafaultItem'] = false

function X.MinionThink( hMinionUnit )

	if Minion.IsValidUnit( hMinionUnit )
		and hMinionUnit:GetUnitName() ~= "npc_dota_clinkz_skeleton_archer"
	then
		Minion.IllusionThink( hMinionUnit )
	end

end

--[[

npc_dota_hero_clinkz

7.23
"Ability1"		"clinkz_death_pact"
"Ability2"		"clinkz_searing_arrows"
"Ability3"		"clinkz_wind_walk"
"Ability4"		"generic_hidden"
"Ability5"		"generic_hidden"
"Ability6"		"clinkz_burning_army"
"Ability10"		"special_bonus_agility_8"
"Ability11"		"special_bonus_strength_10"
"Ability12"		"special_bonus_unique_clinkz_5"
"Ability13"		"special_bonus_unique_clinkz_1"
"Ability14"		"special_bonus_attack_range_125"
"Ability15"		"special_bonus_unique_clinkz_6"
"Ability16"		"special_bonus_unique_clinkz_2"
"Ability17"		"special_bonus_unique_clinkz_3"

modifier_clinkz_skeleton_archer_taunt_anim
modifier_clinkz_strafe
modifier_clinkz_searing_arrows
modifier_clinkz_wind_walk
modifier_clinkz_death_pact
modifier_clinkz_burning_army_thinker
modifier_clinkz_burning_army


--]]

local abilityQ = bot:GetAbilityByName( sAbilityList[1] )
local abilityW = bot:GetAbilityByName( sAbilityList[2] )
local abilityE = bot:GetAbilityByName( sAbilityList[3] )
local abilityD = bot:GetAbilityByName( sAbilityList[4] )
local abilityF = bot:GetAbilityByName( sAbilityList[5] )
local abilityR = bot:GetAbilityByName( sAbilityList[6] )
local talent4 = bot:GetAbilityByName( sTalentList[4] )

local castQDesire, castQTarget
local castWDesire, castWTarget
local castEDesire, castWTarget
local castRDesire, castRTarget

local nKeepMana, nMP, nHP, nLV, hEnemyList, hAllyList, botTarget, sMotive
local aetherRange = 0

function X.SkillsComplement()

	if J.CanNotUseAbility( bot ) then return end

	nKeepMana = 200
	aetherRange = 0
	nLV = bot:GetLevel()
	nMP = bot:GetMana()/bot:GetMaxMana()
	nHP = bot:GetHealth()/bot:GetMaxHealth()
	botTarget = J.GetProperTarget( bot )
	hEnemyList = bot:GetNearbyHeroes( 1600, true, BOT_MODE_NONE )
	hAllyList = J.GetAlliesNearLoc( bot:GetLocation(), 1600 )


	
	aetherRange = J.GetBonusCastRange( bot )

	castEDesire, sMotive = X.ConsiderE()
	if ( castEDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )

		J.SetQueuePtToINT( bot, true )

		bot:ActionQueue_UseAbility( abilityE )
		return
	end

	castRDesire, sMotive = X.ConsiderR()
	if ( castRDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )

		J.SetQueuePtToINT( bot, true )

		bot:ActionQueue_UseAbility( abilityR )
		return
	end

	castQDesire, sMotive = X.ConsiderQ()
	if ( castQDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )

		J.SetQueuePtToINT( bot, true )

		bot:ActionQueue_UseAbility( abilityQ )
		return
	end

	castWDesire, castWTarget, sMotive = X.ConsiderW()
	if ( castWDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )

		local mp = bot:GetMana()
		if abilityR:IsFullyCastable() and mp > 250 then
			bot:ActionQueue_UseAbility(abilityR)
		end
		if not abilityD:IsHidden() and abilityD:IsFullyCastable() and mp > 400 then
			bot:ActionQueue_UseAbilityOnLocation(abilityD, (bot:GetLocation() + castWTarget:GetLocation()) / 3)
		end
		bot:ActionQueue_UseAbilityOnEntity( abilityW, castWTarget )
		if abilityQ:IsFullyCastable() then
			bot:ActionQueue_UseAbility(abilityQ)
		end
		return
	end

end


function X.ConsiderE()


	if not abilityE:IsFullyCastable() then return 0 end

	local nSkillLV = abilityE:GetLevel()
	local nCastRange = abilityE:GetCastRange() + aetherRange + 32
	local nCastPoint = abilityE:GetCastPoint()
	local nManaCost = abilityE:GetManaCost()
	local nDamage = abilityE:GetAbilityDamage()
	local nDamageType = DAMAGE_TYPE_MAGICAL

	if #hEnemyList == 0 then nCastRange = 1600 end

	local nEnemyCreepList = bot:GetNearbyCreeps( nCastRange, true )

	local nBestCreep = nil

	local targetCreepBountyGoldMax = 0
	for _, nCreep in pairs( nEnemyCreepList )
	do
		if J.IsValid( nCreep )
			and not nCreep:IsHero()
			and not nCreep:IsAncientCreep()
			and not nCreep:IsMagicImmune()
			and nCreep:GetHealth() > targetCreepBountyGoldMax
		then
			nBestCreep = nCreep
			targetCreepBountyGoldMax = nCreep:GetHealth()
		end
	end

	if nBestCreep ~= nil 
	then
		return BOT_ACTION_DESIRE_HIGH, nBestCreep, "R-吃敌方兵:"..nBestCreep:GetUnitName()
	end
	
	local nAllyCreepList = bot:GetNearbyCreeps( nCastRange, false )
	
	for _, nCreep in pairs( nAllyCreepList )
	do
		if J.IsValid( nCreep )
			and not nCreep:IsHero()
			and not nCreep:IsAncientCreep()
			and not nCreep:IsMagicImmune()
			and nCreep:GetHealth() > targetCreepBountyGoldMax
		then
			nBestCreep = nCreep
			targetCreepBountyGoldMax = nCreep:GetHealth()
		end
	end

	if nBestCreep ~= nil 
	then
		return BOT_ACTION_DESIRE_HIGH, nBestCreep, "R-吃友方兵:"..nBestCreep:GetUnitName()
	end
	
	return BOT_ACTION_DESIRE_NONE


end



local lastAutoTime = 0
function X.ConsiderW()

	if not abilityW:IsFullyCastable() then return BOT_ACTION_DESIRE_NONE end

	local nCastRange = bot:GetAttackRange() --不考虑combo，必须挨得够近
	local nCastPoint = abilityW:GetCastPoint()
	local nSkillLV = abilityW:GetLevel()

	local nEnemysHeroesInCastRange = bot:GetNearbyHeroes( nCastRange + 99, true, BOT_MODE_NONE )
	local nEnemysHeroesInView = bot:GetNearbyHeroes( 880, true, BOT_MODE_NONE )

	--追杀
	if J.IsGoingOnSomeone( bot ) then
		local target = J.GetProperTarget( bot )
		if J.IsValidHero( target )
			and J.CanCastOnNonMagicImmune( target )
			and J.CanCastOnTargetAdvanced( target )
			and J.IsInRange( target, bot, nCastRange ) then
			return BOT_ACTION_DESIRE_HIGH, target
		end
	end

	--逃跑
	if J.IsRetreating( bot )
	then
		if J.IsValid( nEnemysHeroesInCastRange[1] )
			and J.CanCastOnNonMagicImmune( nEnemysHeroesInCastRange[1] )
			and J.CanCastOnTargetAdvanced( nEnemysHeroesInCastRange[1] )
			and not J.IsDisabled( nEnemysHeroesInCastRange[1] )
			and not nEnemysHeroesInCastRange[1]:IsDisarmed()
			and GetUnitToUnitDistance( bot, nEnemysHeroesInCastRange[1] ) <= nCastRange - 60
		then
			return BOT_ACTION_DESIRE_HIGH, nEnemysHeroesInCastRange[1]
		end
	end

	return BOT_ACTION_DESIRE_NONE
end

function X.ConsiderR()

	local nEnemyTowers = bot:GetNearbyTowers( 888, true )

	if not abilityR:IsFullyCastable()
		or bot:IsInvisible()
		or #nEnemyTowers >= 1
		or bot:HasModifier( "modifier_item_dustofappearance" )
		or bot:DistanceFromFountain() < 800
	then return BOT_ACTION_DESIRE_NONE end

	local nSkillLV = abilityR:GetLevel()
	local nCastRange = abilityR:GetCastRange()
	local nCastPoint = abilityR:GetCastPoint()
	local nManaCost = abilityR:GetManaCost()
	local nDamage = abilityR:GetAbilityDamage()
	local nDamageType = DAMAGE_TYPE_MAGICAL
	local nInRangeEnemyList = bot:GetNearbyHeroes( nCastRange, true, BOT_MODE_NONE )

	if J.IsRetreating( bot )
		and bot:GetActiveModeDesire() > BOT_MODE_DESIRE_HIGH
		and #hEnemyList > 0
	then
		return BOT_ACTION_DESIRE_HIGH, 'R-撤退了'
	end

	if J.GetHP( bot ) < 0.166
		and ( #hEnemyList > 0 or bot:WasRecentlyDamagedByAnyHero( 5.0 ) )
	then
		return BOT_ACTION_DESIRE_HIGH, 'R-隐身保命'
	end

	if J.IsGoingOnSomeone( bot )
	then
		if J.IsValidHero( botTarget )
			and J.CanCastOnMagicImmune( botTarget )
		then
			if not J.IsInRange( bot, botTarget, botTarget:GetCurrentVisionRange() )
				and J.IsInRange( bot, botTarget, 3000 )
			then
				local hEnemyCreepList = bot:GetNearbyLaneCreeps( 700, true )
				if #hEnemyCreepList == 0 and #hEnemyList == 0
				then
					return BOT_ACTION_DESIRE_HIGH, 'R-隐身攻击:'..J.Chat.GetNormName( botTarget )
				end
			end

			if J.IsChasingTarget( bot, botTarget )
				and J.IsInRange( bot, botTarget, 1000 )
			then
				return BOT_ACTION_DESIRE_HIGH, 'R-隐身追击:'..J.Chat.GetNormName( botTarget )
			end

		end
	end

	if J.IsInEnemyArea( bot )
		and nLV >= 9
		and J.IsRunning( bot )
	then
		local nEnemies = bot:GetNearbyHeroes( 1600, true, BOT_MODE_NONE )
		local nAllies = bot:GetNearbyHeroes( 1400, true, BOT_MODE_NONE )
		local nEnemyTowers = bot:GetNearbyTowers( 1400, true )
		if #nEnemies == 0 and #nAllies <= 2 and nEnemyTowers == 0
		then
			return BOT_ACTION_DESIRE_HIGH, 'R-敌方地区潜行'
		end
	end

	return BOT_ACTION_DESIRE_NONE


end

function X.ConsiderQ()


	if not abilityQ:IsFullyCastable() 
	then return 0 end

	local nSkillLV = abilityQ:GetLevel()
	local nCastRange = bot:GetAttackRange()
	local nCastPoint = abilityQ:GetCastPoint()
	local nManaCost = abilityQ:GetManaCost()
	local nDamage = abilityQ:GetAbilityDamage()
	local nInRangeEnemyList = bot:GetNearbyHeroes( nCastRange, true, BOT_MODE_NONE )

	--攻击敌人
	if J.IsGoingOnSomeone(bot)
	then
		if J.IsValidHero(botTarget)
			and J.IsInRange(bot, botTarget, nCastRange)
		then
			return BOT_ACTION_DESIRE_HIGH,"Q-攻击"
		end
	end

	return BOT_ACTION_DESIRE_NONE

end


return X
-- dota2jmz@163.com QQ:2462331592..
