local X = {}
local bDebugMode = false
local bot = GetBot()

local J = require( GetScriptDirectory()..'/FunLib/jmz_func' )
local Minion = dofile( GetScriptDirectory()..'/FunLib/aba_minion' )
local sTalentList = J.Skill.GetTalentList( bot )
local sAbilityList = J.Skill.GetAbilityList( bot )
local sOutfitType = J.Item.GetOutfitType( bot )

local tTalentTreeList = {
						['t25'] = {10, 0},
						['t20'] = {0, 10},
						['t15'] = {10, 0},
						['t10'] = {0, 10},
}

local tAllAbilityBuildList = {
    {1,2,3,3,3,6,3,1,1,1,2,6,2,2,},
}

local nAbilityBuildList = J.Skill.GetRandomBuild( tAllAbilityBuildList )

local nTalentBuildList = J.Skill.GetTalentBuild( tTalentTreeList )

local tOutFitList = {}

tOutFitList['outfit_tank'] = {

	"item_bristleback_outfit",
	"item_vanguard",
    "item_aghanims_shard",
	"item_crimson_guard",
    "item_blink",
	"item_pipe",
	"item_heart",
	"item_overwhelming_blink",
	"item_radiance",
	"item_ultimate_scepter_2",
}

tOutFitList['outfit_mid'] = tOutFitList['outfit_tank']

tOutFitList['outfit_carry'] = tOutFitList['outfit_tank']

tOutFitList['outfit_priest'] = tOutFitList['outfit_tank']

tOutFitList['outfit_mage'] = tOutFitList['outfit_tank']

X['sBuyList'] = tOutFitList[sOutfitType]

X['sSellList'] = {
	"item_power_treads",
    "item_quelling_blade",
    
	"item_vanguard",
    "item_bracer",

    "item_blink",
	"item_magic_wand",
}

if J.Role.IsPvNMode() or J.Role.IsAllShadow() then X['sBuyList'], X['sSellList'] = { 'PvN_tank' }, {} end

nAbilityBuildList, nTalentBuildList, X['sBuyList'], X['sSellList'] = J.SetUserHeroInit( nAbilityBuildList, nTalentBuildList, X['sBuyList'], X['sSellList'] )

X['sSkillList'] = J.Skill.GetSkillList( sAbilityList, nAbilityBuildList, sTalentList, nTalentBuildList )

X['bDeafaultAbility'] = true
X['bDeafaultItem'] = true

function X.MinionThink( hMinionUnit )

	if Minion.IsValidUnit( hMinionUnit )
	then
		Minion.IllusionThink( hMinionUnit )
	end

end

local abilityQ = bot:GetAbilityByName( sAbilityList[1] )
local abilityW = bot:GetAbilityByName( sAbilityList[2] )
local abilityD = bot:GetAbilityByName( sAbilityList[4] )
local abilityR = bot:GetAbilityByName( sAbilityList[6] )

local castQDesire
local castWDesire, castWTarget
local castDDesire, castDTarget
local castRDesire

local nKeepMana, nMP, nHP, nLV, hEnemyList, hAllyList, botTarget, sMotive
local aetherRange = 0

function X.SkillsComplement()

	if J.CanNotUseAbility( bot ) or bot:IsInvisible() then return end

	nKeepMana = 350
	aetherRange = 0
	nLV = bot:GetLevel()
	nMP = bot:GetMana()/bot:GetMaxMana()
	nHP = bot:GetHealth()/bot:GetMaxHealth()
	botTarget = J.GetProperTarget( bot )
	hEnemyList = bot:GetNearbyHeroes( 1600, true, BOT_MODE_NONE )
	hAllyList = J.GetAlliesNearLoc( bot:GetLocation(), 1600 )

	
	aetherRange = J.GetBonusCastRange( bot )

    castQDesire, sMotive = X.ConsiderQ()
    if ( castQDesire > 0 ) then

        J.SetReportMotive( bDebugMode, sMotive )

        J.SetQueuePtToINT( bot, true )

        bot:ActionQueue_UseAbility( abilityQ )

        return
    end

	castWDesire, castWTarget, sMotive = X.ConsiderW()
	if ( castWDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )

		J.SetQueuePtToINT( bot, false )

		bot:ActionQueue_UseAbilityOnEntity( abilityW, castWTarget )
		return

	end

	castRDesire, sMotive = X.ConsiderR()
	if ( castRDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )

		J.SetQueuePtToINT( bot, true )

		bot:ActionQueue_UseAbility( abilityR )
		return
	end

end

function X.ConsiderQ()

	if not abilityQ:IsFullyCastable() then return 0 end

	local nSkillLV = abilityQ:GetLevel()
	local nRadius = abilityQ:GetSpecialValueInt( 'radius' )
	local nCastPoint = abilityQ:GetCastPoint()
	local nManaCost = abilityQ:GetManaCost()
	local nDamage = abilityQ:GetAbilityDamage()
	local nDamageType = DAMAGE_TYPE_MAGICAL
	local nInRangeEnemyList = bot:GetNearbyHeroes( nRadius + 300, true, BOT_MODE_NONE )
    local hCastTarget
    local sCastMotive

	--打断敌人施法
	for _, npcEnemy in pairs( nInRangeEnemyList )
	do 
		if npcEnemy:IsChanneling()
			and not npcEnemy:IsMagicImmune()
		then
			hCastTarget = npcEnemy
			sCastMotive = 'Q-打断'..J.Chat.GetNormName( hCastTarget )
			return BOT_ACTION_DESIRE_HIGH, sCastMotive
		end
	end
	
	
	--攻击敌人时
	if J.IsGoingOnSomeone( bot )
	then
		local loc = J.GetCorrectLoc(botTarget, nCastPoint)
		if J.IsValidHero( botTarget )
			and J.GetDistanceFromUnitToVector(bot, loc) < nRadius
			and J.CanCastOnNonMagicImmune( botTarget )
			and (not J.IsDisabled( botTarget ) or J.GetRemainStunTime(botTarget)< nCastPoint + 0.5)
		then
			hCastTarget = botTarget
			sCastMotive = 'Q-先手'..J.Chat.GetNormName( hCastTarget )
			return BOT_ACTION_DESIRE_HIGH, sCastMotive
		end
	end

	--打肉时
	if bot:GetActiveMode() == BOT_MODE_ROSHAN
	then
		if J.IsRoshan( botTarget )
			and not J.IsDisabled( botTarget )
			and J.IsInRange( botTarget, bot, nRadius )
		then
			hCastTarget = botTarget
			sCastMotive = 'Q-肉山'
			return BOT_ACTION_DESIRE_HIGH, sCastMotive
		end
	end

	return BOT_ACTION_DESIRE_NONE

end

function X.ConsiderW()

	if not abilityW:IsFullyCastable() then return 0 end

	local castRange = abilityW:GetCastRange() + aetherRange

	local target = J.GetProperTarget( bot )
	local aTarget = bot:GetAttackTarget()
    local nDamage = abilityW:GetAbilityDamage()
    local nCastPoint = abilityW:GetCastPoint()
	local enemies = bot:GetNearbyHeroes( castRange, true, BOT_MODE_NONE )
	local nRadius = abilityW:GetVal('radius')

	if aTarget ~= nil
		and aTarget:IsAlive()
		and J.IsInRange( aTarget, bot, castRange )
        and nHP > 0.6
	then
		return BOT_ACTION_DESIRE_HIGH, aTarget, "W-攻击"
	end

	if target ~= nil
		and target:IsAlive()
		and J.IsInRange( target, bot, castRange )
        and (nHP > 0.3 or J.WillMagicKillTarget(bot, target, nDamage,nCastPoint))
	then
		return BOT_ACTION_DESIRE_HIGH, aTarget, "W-攻击当前目标"
	end

	if (J.IsPushing( bot ) or J.IsDefending( bot ) or J.IsLaning(bot)) and nHP > 0.7
	then
		local creeps = bot:GetNearbyLaneCreeps( castRange + 600, true )

		local maxHit = 0
		local maxHitCreep = nil

		for _,creep in pairs(creeps) do
			local hit = 0
			local kill = 0
			for cr in creeps do
				if cr~=creep and cr:GetDistanceToUnit(creep) < nRadius then
					hit = hit + 1
					if creep:GetHealth() < nDamage then
						kill = kill + 1
					end
				end
			end
			if maxHit < hit and kill > 0 then
				maxHit = hit
				maxHitCreep = creep
			end
		end
		if maxHitCreep then return BOT_ACTION_DESIRE_HIGH, maxHitCreep, "W-推进" end
	end

	if J.IsGoingOnSomeone( bot )
	then
		if J.IsValidHero( target )
			and J.CanCastOnNonMagicImmune( target )
			and J.IsInRange( target, bot, castRange )
            and (nHP > 0.3 or J.WillMagicKillTarget(bot, target, nDamage,nCastPoint))
		then
			return BOT_ACTION_DESIRE_HIGH, target, "W-追杀"
		end
	end

	return BOT_ACTION_DESIRE_NONE

end

function X.ConsiderR()
	local nInRangeEnemyList = bot:GetNearbyHeroes( 600, true, BOT_MODE_NONE )
	local target = J.GetProperTarget( bot )

	if not abilityR:IsFullyCastable() then return 0 end

	if J.IsInTeamFight(bot,800) then
		return BOT_ACTION_DESIRE_HIGH, "R-团战"
	end

	if J.IsGoingOnSomeone( bot )
	then
		if J.IsValidHero( target )
			and J.CanCastOnNonMagicImmune( target )
			and (not J.IsInRange( target, bot, 300 ))
		then
			return BOT_ACTION_DESIRE_HIGH, "R-追杀"
		end
	end

    
	for i = 1, 5
	do 
		local npcAlly = GetTeamMember( i )
		if npcAlly ~= nil
			and npcAlly:IsAlive()
            and nHP < 0.2 and npcAlly:WasRecentlyDamagedByAnyHero(2.0)
			and not npcAlly:IsStunned()
			and npcAlly:GetCurrentMovementSpeed() < 500
		then
			return BOT_ACTION_DESIRE_HIGH, "R-帮助队友逃跑"
        end
    end

	return BOT_ACTION_DESIRE_NONE

end

function X.ConsiderD()

	if not abilityD:IsFullyCastable() then return 0 end

	local nSkillLV = abilityD:GetLevel()
	local nCastRange = abilityD:GetCastRange() + aetherRange
	local nRadius = 600
	local nCastPoint = abilityD:GetCastPoint()
	local nManaCost = abilityD:GetManaCost()
	local nDamage = 0
	local nDamageType = DAMAGE_TYPE_MAGICAL
--	local nInRangeEnemyList = J.GetAroundEnemyHeroList( nCastRange )
--	local nInBonusEnemyList = J.GetAroundEnemyHeroList( nCastRange + 200 )
	local hCastTarget = nil
	local sCastMotive = nil

	for _, npcAlly in pairs( hAllyList ) do
		if J.IsValidHero( npcAlly )
			and J.IsInRange( bot, npcAlly, nCastRange + 300 )
			and not npcAlly:IsMagicImmune()
			and not npcAlly:IsInvulnerable()
			and not npcAlly:IsIllusion()
		then
		
			--救援被控制队友
			if J.IsDisabled( npcAlly )
			then
				hCastTarget = npcAlly
				sCastMotive = 'D-救援被控制队友:'..J.Chat.GetNormName( hCastTarget )
				return BOT_ACTION_DESIRE_HIGH, hCastTarget, sCastMotive
			end
			
			
			--为准备打架的远程队友辅助
			if J.IsGoingOnSomeone( npcAlly )
				and npcAlly:GetAttackRange() > 300
			then
				local allyTarget = J.GetProperTarget( npcAlly )
				if J.IsValidHero( allyTarget ) then
					hCastTarget = npcAlly
					sCastMotive = 'W-辅助队友进攻:'..J.Chat.GetNormName( hCastTarget )
					return BOT_ACTION_DESIRE_HIGH, hCastTarget, sCastMotive
				end
			end
			
			--救援残血队友
			if ( npcAlly:WasRecentlyDamagedByAnyHero( 5.0 ) or J.GetHP( npcAlly ) < 0.25 )
				and not npcAlly:HasModifier( 'modifier_fountain_aura' )
			then
				hCastTarget = npcAlly
				sCastMotive = 'W-救援残血队友:'..J.Chat.GetNormName( hCastTarget )
				return BOT_ACTION_DESIRE_HIGH, hCastTarget, sCastMotive
			end

		end
	end


	return BOT_ACTION_DESIRE_NONE

end


return X



