local X = {}
local bDebugMode = false
local bot = GetBot()

local J = require( GetScriptDirectory()..'/FunLib/jmz_func' )
local Minion = dofile( GetScriptDirectory()..'/FunLib/aba_minion' )
local sTalentList = J.Skill.GetTalentList( bot )
local sAbilityList = J.Skill.GetAbilityList( bot )
local sOutfitType = J.Item.GetOutfitType( bot )

local tTalentTreeList = {
						['t25'] = {10, 0},
						['t20'] = {10, 0},
						['t15'] = {10, 0},
						['t10'] = {10, 0},
}

local tAllAbilityBuildList = {
    {2,3,2,1,2,6,2,1,1,1,6,3,3,3,6},
}

local nAbilityBuildList = J.Skill.GetRandomBuild( tAllAbilityBuildList )

local nTalentBuildList = J.Skill.GetTalentBuild( tTalentTreeList )

local tOutFitList = {}

tOutFitList['outfit_priest'] = {

	"item_mage_outfit",
	"item_glimmer_cape",
--	"item_rod_of_atos",
	"item_aghanims_shard",
	"item_holy_locket",
	"item_lotus_orb",
	"item_ultimate_scepter",
	"item_cyclone",
	"item_sheepstick",
	"item_wind_waker",
	"item_moon_shard",

}

tOutFitList['outfit_tank'] = {

	"item_priest_outfit",
	"item_urn_of_shadows",
	"item_mekansm",
	"item_glimmer_cape",
	"item_aghanims_shard",
	"item_holy_locket",
	"item_guardian_greaves",
	"item_spirit_vessel",
	"item_assault",
	"item_shivas_guard",
--	"item_sheepstick", 
	"item_moon_shard",

}

tOutFitList['outfit_mid'] = tOutFitList['outfit_tank']

tOutFitList['outfit_carry'] = tOutFitList['outfit_tank']

tOutFitList['outfit_mage'] = tOutFitList['outfit_priest']

X['sBuyList'] = tOutFitList[sOutfitType]

X['sSellList'] = {
	"item_ultimate_scepter",
	"item_magic_wand",
}

if J.Role.IsPvNMode() or J.Role.IsAllShadow() then X['sBuyList'], X['sSellList'] = { 'PvN_mage' }, {} end

nAbilityBuildList, nTalentBuildList, X['sBuyList'], X['sSellList'] = J.SetUserHeroInit( nAbilityBuildList, nTalentBuildList, X['sBuyList'], X['sSellList'] )

X['sSkillList'] = J.Skill.GetSkillList( sAbilityList, nAbilityBuildList, sTalentList, nTalentBuildList )

X['bDeafaultAbility'] = true
X['bDeafaultItem'] = true

function X.MinionThink( hMinionUnit )

	if Minion.IsValidUnit( hMinionUnit )
	then
		Minion.IllusionThink( hMinionUnit )
	end

end

--[[

npc_dota_hero_abaddon

    "Ability1"		"abaddon_death_coil"
    "Ability2"		"abaddon_aphotic_shield"
    "Ability3"		"abaddon_frostmourne"
    "Ability4"		"generic_hidden"
    "Ability5"		"generic_hidden"
    "Ability6"		"abaddon_borrowed_time"
    "Ability10"		"special_bonus_movement_speed_15"
    "Ability11"		"special_bonus_strength_8"
    "Ability12"		"special_bonus_attack_damage_65"
    "Ability13"		"special_bonus_unique_abaddon_2"
    "Ability14"		"special_bonus_unique_abaddon"
    "Ability15"		"special_bonus_unique_abaddon_5"
    "Ability16"		"special_bonus_unique_abaddon_3"
    "Ability17"		"special_bonus_unique_abaddon_4"

    modifier_abaddon_aphotic_shield

--]]

local abilityQ = bot:GetAbilityByName( sAbilityList[1] )
local abilityW = bot:GetAbilityByName( sAbilityList[2] )
local abilityR = bot:GetAbilityByName( sAbilityList[6] )

local castQDesire, castQTarget
local castWDesire, castWTarget
local castRDesire

local nKeepMana, nMP, nHP, nLV, hEnemyList, hAllyList, botTarget, sMotive
local aetherRange = 0

function X.SkillsComplement()

	if J.CanNotUseAbilityIgnoreStun( bot ) or bot:IsInvisible() then return end

	nKeepMana = 350
	aetherRange = 0
	nLV = bot:GetLevel()
	nMP = bot:GetMana()/bot:GetMaxMana()
	nHP = bot:GetHealth()/bot:GetMaxHealth()
	botTarget = J.GetProperTarget( bot )
	hEnemyList = bot:GetNearbyHeroes( 1600, true, BOT_MODE_NONE )
	hAllyList = J.GetAlliesNearLoc( bot:GetLocation(), 1600 )

	aetherRange = J.GetBonusCastRange( bot )

	castRDesire, sMotive = X.ConsiderR()
	if ( castRDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )

		J.SetQueuePtToINT( bot, true )

		bot:ActionQueue_UseAbility( abilityR )
		return
	end

	if bot:IsStunned() then return end

    castQDesire, castQTarget, sMotive = X.ConsiderQ()
    if ( castQDesire > 0 ) then

        J.SetReportMotive( bDebugMode, sMotive )

        J.SetQueuePtToINT( bot, true )

        bot:ActionQueue_UseAbilityOnEntity( abilityQ, castQTarget )

        return
    end

	castWDesire, castWTarget, sMotive = X.ConsiderW()
	if ( castWDesire > 0 )
	then
		J.SetReportMotive( bDebugMode, sMotive )

		J.SetQueuePtToINT( bot, false )

		bot:ActionQueue_UseAbilityOnEntity( abilityW, castWTarget )
		return

	end

end

function X.ConsiderQ()

	if not abilityQ:IsFullyCastable() then return 0 end

	local nSkillLV = abilityQ:GetLevel()
	local nCastRange = abilityQ:GetCastRange() + aetherRange
	local nCastPoint = abilityQ:GetCastPoint()
	local nManaCost = abilityQ:GetManaCost()
	local nDamage = abilityQ:GetAbilityDamage()
	local nDamageType = DAMAGE_TYPE_MAGICAL
	local nInRangeEnemyList = bot:GetNearbyHeroes( nCastRange, true, BOT_MODE_NONE )
	local heroList = FilterTable(nInRangeEnemyList,function(u)
		return J.IsValidHero(u) and J.IsInRange( bot, u, nCastRange )
		and J.CanCastOnNonMagicImmune(u)
	end)

	--击杀，WR期间无脑用
	for _, npcEnemy in pairs(heroList)
	do
		if J.WillMagicKillTarget(bot, npcEnemy, nDamage, nCastPoint + 1.0)
				or J.GetModifierTime(bot, 'modifier_abaddon_borrowed_time')>nCastPoint
				or J.GetModifierTime(bot, 'modifier_abaddon_borrowed_time_immolate')>nCastPoint
				or J.GetModifierTime(bot, 'modifier_abaddon_aphotic_shield')>nCastPoint then
			return BOT_ACTION_DESIRE_HIGH, npcEnemy, "Q-对"..J.Chat.GetNormName( npcEnemy ).."耗血"
		end
	end

	--治疗队友
	for _, npcAlly in pairs( hAllyList )
	do
		if J.IsValidHero( npcAlly )
			and J.IsAllysTarget( npcAlly )
			and npcAlly ~= bot
			and J.IsInRange( bot, npcAlly, nCastRange )
			and J.CanCastOnNonMagicImmune( npcAlly )
            and (J.GetHP( npcAlly ) < 0.3 or ((J.IsPushing(npcAlly) or npcAlly:WasRecentlyDamagedByAnyHero(3.0)) and J.GetHP(npcAlly)<0.7))
		then
			return BOT_ACTION_DESIRE_HIGH, npcAlly, "Q-治疗"..J.Chat.GetNormName( npcAlly )
		end
	end

    --攻击敌人
	if J.IsGoingOnSomeone( bot ) and J.IsValidHero( botTarget )
			and J.IsInRange( bot, botTarget, nCastRange )
			and J.CanCastOnNonMagicImmune( botTarget)
            and (nSkillLV>2 or J.WillMagicKillTarget(bot, botTarget, nDamage, nCastPoint))
			and (J.GetHP(bot)>J.GetHP(botTarget)
				or J.GetModifierTime(bot, 'modifier_abaddon_borrowed_time')>nCastPoint
				or J.GetModifierTime(bot, 'modifier_abaddon_aphotic_shield')>nCastPoint) then
		return BOT_ACTION_DESIRE_HIGH, botTarget, "Q-攻击"..J.Chat.GetNormName( botTarget )
	end

	return BOT_ACTION_DESIRE_NONE

end

function X.ConsiderW()

	if not abilityW:IsFullyCastable() then return 0 end

	local nSkillLV = abilityQ:GetLevel()
	local nCastRange = abilityQ:GetCastRange() + aetherRange
	local nRadius = abilityQ:GetSpecialValueInt( 'radius' )
	local nCastPoint = abilityQ:GetCastPoint()
	local nManaCost = abilityQ:GetManaCost()
	local nDamage = abilityQ:GetSpecialValueInt( 'heal' )
	
	local nInRangeEnemyList = J.GetAroundEnemyHeroList( nCastRange + nRadius )
	local nInBonusEnemyList = J.GetAroundEnemyHeroList( nCastRange + 200 + nRadius )
	
	local nInRangeAllyHeroList = bot:GetNearbyHeroes( nCastRange + 350, false, BOT_MODE_NONE )
	local nInRangeAllyCreepList = bot:GetNearbyCreeps( nCastRange + 200, false )
	
	local hCastTarget = nil
	local sCastMotive = nil

	--奶队友，包含解状态
	for i = 1, 5
	do
		local npcAlly = GetTeamMember(i)
		if npcAlly ~= nil
			and npcAlly:IsAlive()
			and not npcAlly:HasModifier( 'modifier_fountain_aura' )
			and not npcAlly:HasModifier( 'modifier_abaddon_aphotic_shield' )
			and J.IsInRange( bot, npcAlly, nCastRange )
			and ( J.GetHP( npcAlly ) < 0.3
					or ( J.GetHP( npcAlly ) < 0.5 and npcAlly:WasRecentlyDamagedByAnyHero( 3.0 ) ) 
					or J.GetRemainStunTime(npcAlly)>1.0+nCastPoint)
		then
			hCastTarget = npcAlly
			sCastMotive = 'W-奶队友:'..J.Chat.GetNormName( hCastTarget )
			return BOT_ACTION_DESIRE_HIGH, hCastTarget, sCastMotive
		end
	end

	return BOT_ACTION_DESIRE_NONE

end

function X.ConsiderR()
	local nInRangeEnemyList = bot:GetNearbyHeroes( 600, true, BOT_MODE_NONE )

	if not abilityR:IsFullyCastable() then return 0 end

	--解晕，旁边人越多阈值越高
    if J.GetRemainStunTime(bot) > 1.0 and J.GetHP(bot)<(0.5+0.1*#nInRangeEnemyList) then
		return BOT_ACTION_DESIRE_HIGH, bot, "R-解晕"..J.Chat.GetNormName( bot )
    end

	if J.IsInTeamFight(bot,800) and bot:HasScepter() then
		return BOT_ACTION_DESIRE_HIGH, bot, "R-团战A杖"..J.Chat.GetNormName( bot )
	end

	return BOT_ACTION_DESIRE_NONE

end


return X



