ygopro.ctos_follow_after("UPDATE_DECK", true, (buffer, info, client, server, datas) => {
    var room = ROOM_all[client.rid];
    if (!room) { //无房间则返回
        return null;
    }
    if (room.duel_stage != ygopro.constants.DUEL_STAGE.BEGIN) {
        return null; //非决斗开始时则返回
    }
    if (client.is_local) {
	    return null; //Windbot则返回
    }
    var room_parameters = room.name.split('#', 2)[0].split(/[,，]/); //房间名的参数
    var found = false;
    for(var parameter of room_parameters) {
        if (parameter.toUpperCase() == "DC") { //关键字[DC]
            found = true;
            break;
        }
    }
    if (!found) {
        return null; //无DC不做处理
    }
    var index = global.dc_decks_index;
    global.dc_decks_index++;
    if (global.dc_decks_index > 99) {
	    global.dc_decks_index = 0;
    }
        var buff_main_new = global.dc_decks_main[index];
    var buff_side_new = global.dc_decks_side[index];
    client.main = buff_main_new;
    client.side = buff_side_new;

    var compat_deckbuf = buff_main_new.concat(buff_side_new); //拼接buffer
    //while (compat_deckbuf.length < 90){
    //    compat_deckbuf.push(0);
    //}

    ygopro.ctos_send(server, "UPDATE_DECK", {
        mainc: client.main.length,
        sidec: client.side.length,
        deckbuf: compat_deckbuf
    });

    var sql = "SELECT * FROM RandomDecks ORDER BY RAND() LIMIT 1;"
	global.mysqldb.query(sql, function(err, result) {
	    if (result == null || result.length == 0) {
	        return null; //无卡组直接返回
	    }
    	var buff_main_replace = [];
    	var buff_side_replace = [];
	    var cards = result[0].content.split(/[\r\n\t ]+/); //卡组按行分割
	    var side = false; //是否在副卡组
	    for(var i=0;i<cards.length;i++) {
	        var code = parseInt(cards[i].trim()); //parse卡片代码
	        if (!isNaN(code)) { //是有效卡片
	            if (!side)
	                buff_main_replace.push(code);
	            else
	                buff_side_replace.push(code); //buffer内追加卡片
	        }
	        else if (cards[i].substring(0,5) == "!side") {
	            side = true; //检测到!side后，后续卡片加入副卡组
	        }
	    }
	    global.dc_decks_main[index] = buff_main_replace;
	    global.dc_decks_side[index] = buff_side_replace;
	});
	return true;
});

ygopro.stoc_follow_after("CHANGE_SIDE", true, (buffer, info, client, server, datas) => {
	var room = ROOM_all[client.rid];
	if (!room) {
		return false;
	}
	var room_parameters = room.name.split('#', 2)[0].split(/[,，]/); //房间名的参数
	var found = false;
	for(var parameter of room_parameters) {
            if (parameter.toUpperCase() == "DC") { //关键字[DC]
                found = true;
                break;
	    }
	}
	if (!found) {
	    return null; //无DC不做处理
	}

	ygopro.ctos_send(server, "UPDATE_DECK", {
		mainc: client.main.length,
		sidec: client.side.length,
		deckbuf: client.main.concat(client.side)
	});
	if (client.side_interval) {
		clearInterval(client.side_interval);
	}
	return true;
});