var _ = require('underscore');
var cards = require('./cards.js');

var gameList = [];

function getDeck() {
  try {
    return cards.getDeck();
  }
  catch{
    return null;
  }
  
}

function removeFromArray(array, item) {
  try {
    var index = array.indexOf(item);
    if(index != -1) array.splice(index, 1);
  }
  catch{
    return null;
  }
}

function list() {
  try {
    return toInfo(_.filter(gameList, function(x) {
      return x.players.length < x.maxPlayers;
    }));
  }
  catch{
    return null;
  }
}

function listAll() {
  try {
    return toInfo(gameList);
  }
  catch{
    return null;
  }
}

function toInfo(fullGameList) {
  try {
    return _.map(fullGameList, function(game) {
      return { id: game.id, name: game.name, players: game.players.length, maxPlayers:game.maxPlayers };
    }); 
  }
  catch{
    return null;
  }
}

function addGame(game) {
  try{
    game.players = [];
    game.history = [];
    game.isOver = false;
    game.winnerId = null;
    game.winningCardId = null;
    game.isStarted = false;
    game.deck = getDeck();
    game.currentBlackCard = "";
    game.isReadyForScoring = false;
    game.isReadyForReview = false;
    game.Judge = 0;
    //game.pointsToWin = 5;
    gameList.push(game);
    return game;
  }
  catch {
    return null;
  }
}

function getGame(gameId) {
  try {
    return _.find(gameList, function(x) { return x.id == gameId; });
  }
  catch {
    return null;
  }
}

function joinGame(game, player) {
  try {
    game.players.push({
      id: player.id,
      name: player.name,
      isReady: false,
      selectedWhiteCardId: null,
      awesomePoints: 0,
    });

    if(game.players.length == game.maxPlayers) {
      startGame(game);
    }

    return game;
  }
  catch {
    return null;
  }
}

function startGame(game) {
  try {
    game.isStarted = true;
    setCurrentBlackCard(game);
    _.each(game.players, function(player) {
      player.cards = [];
      for(var i = 0; i < 7; i++) {
        drawWhiteCard(game, player);
      }
    });
  }
  catch {
    return null;
  }
}

function roundEnded(game) {
  try {
    game.winnerId = null;
    game.winningCardId = null;
    game.isReadyForScoring = false;
    game.isReadyForReview = false;

    setCurrentBlackCard(game);

    _.each(game.players, function(player) {
      if(!game.players[game.Judge] != player) {
        removeFromArray(player.cards, player.selectedWhiteCardId);
        while(player.cards.length > 7) {
          (player.cards).splice(0, 1);
        }
        drawWhiteCard(game, player);
      }

      player.isReady = false;
      player.selectedWhiteCardId = null;
    });
    game.Judge++;
    if (game.Judge >= game.maxPlayers) {
      game.Judge = 0;
    }
  }
  catch {
    return null;
  }
}

function drawWhiteCard(game, player) {
  try {
    var whiteIndex = Math.floor(Math.random() * game.deck.white.length);
    player.cards.push(game.deck.white[whiteIndex]);
    game.deck.white.splice(whiteIndex, 1);
  }
  catch {
    return null;
  }
}

function setCurrentBlackCard(game) {
  try {
    var index = Math.floor(Math.random() * game.deck.black.length);
    game.currentBlackCard = game.deck.black[index];
    game.deck.black.splice(index, 1);
  }
  catch {
    return null;
  }
}

function getPlayer(gameId, playerId) {
  try {
    var game = getGame(gameId);
    return _.find(game.players, function(x) { return x.id == playerId; });
  }
  catch {
    return null;
  }
}

function getPlayerByCardId(gameId, cardId) {
  try {
    var game = getGame(gameId);
    return _.findWhere(game.players, { selectedWhiteCardId: cardId });
  }
  catch {
    return null;
  }
}

function readyForNextRound(gameId, playerId) {
  try{
    var player = getPlayer(gameId, playerId);
    player.isReady = true;
  
    var game = getGame(gameId);
    var allReady = _.every(game.players, function(x) {
      return x.isReady;
    });
  
    if(allReady) roundEnded(game);
  }
  catch {
    return null;
  }
  
}

function selectCard(gameId, playerId, whiteCardId) {
  try {
    var player = getPlayer(gameId, playerId);
    var game = getGame(gameId);
    if (playerId == game.players[game.Judge].playerId){
      return null;
    }
    player.selectedWhiteCardId = whiteCardId;
    player.isReady = false;

    var readyPlayers = _.filter(game.players, function (x) {
      return x.selectedWhiteCardId;
    });

    if(readyPlayers.length == (game.players.length - 1))
      game.isReadyForScoring = true;
    }
  catch{
    return null;
  }
}

function selectWinner(gameId, cardId) {
  try{
    var player = getPlayerByCardId(gameId, cardId);
    var game = getGame(gameId);
    game.winningCardId = cardId;
    game.isReadyForReview = true;
    player.awesomePoints = player.awesomePoints + 1;
    game.history.push({ black: game.currentBlackCard, white: cardId, winner: player.name });
  }
  catch{
    return null;
  }
  
  /*if(player.awesomePoints == game.pointsToWin) {
    var game = getGame(gameId);
    game.isOver = true;
    game.winnerId = player.id;
  }*/
}

function reset(){
  gameList = [];
}

exports.list = list;
exports.listAll = listAll;
exports.addGame = addGame;
exports.getGame = getGame;
exports.getPlayer = getPlayer;
exports.joinGame = joinGame;
exports.readyForNextRound = readyForNextRound;
exports.reset = reset;
exports.roundEnded = roundEnded;
exports.selectCard = selectCard;
exports.selectWinner = selectWinner;
exports.removeFromArray = removeFromArray;
exports.getDeck = getDeck;
