﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using System.Web.Script.Serialization;
using System.Windows.Forms;

namespace YRP2Video
{
    public partial class YRP2Video : Form
    {
        public YRP2Video()
        {
            this.InitializeComponent();
        }

        private string UrlEncode(string str)
        {
            return Uri.EscapeDataString(str);
        }
        private string ToBase64(string file)
        {
            byte[] resultArray = File.ReadAllBytes(file);
            string result = Convert.ToBase64String(resultArray, 0, resultArray.Length);
            return result;
        }

        private string HttpGet(string url, Encoding encoding = null)
        {
            if (encoding == null)
            {
                encoding = Encoding.Default;
            }
            string htmlCode = null;
            HttpWebRequest webRequest = (HttpWebRequest)WebRequest.Create(url);
            webRequest.Headers.Add("Authorization", txtAuthKey.Text);
            webRequest.Timeout = 30000;
            webRequest.Method = "GET";
            webRequest.UserAgent = "Mozilla/4.0";
            webRequest.Headers.Add("Accept-Encoding", "gzip, deflate");
            HttpWebResponse webResponse = (HttpWebResponse)webRequest.GetResponse();
            if (webResponse.ContentEncoding.ToLower() == "gzip")//如果使用了GZip则先解压
            {
                Stream streamReceive = webResponse.GetResponseStream();
                var zipStream =
new System.IO.Compression.GZipStream(streamReceive, System.IO.Compression.CompressionMode.Decompress);
                StreamReader sr = new System.IO.StreamReader(zipStream, encoding);
                htmlCode = sr.ReadToEnd();
                sr.Close();
                zipStream.Close();
                streamReceive.Close();
            }
            else
            {
                Stream streamReceive = webResponse.GetResponseStream();
                StreamReader sr = new System.IO.StreamReader(streamReceive, encoding);
                htmlCode = sr.ReadToEnd();
                sr.Close();
                streamReceive.Close();
            }
            return htmlCode.TrimStart('\n');
        }

        private string HttpPost(string url, string data, Encoding encoding = null)
        {
            if (encoding == null)
            {
                encoding = Encoding.Default;
            }
            byte[] bytesToPost = encoding.GetBytes(data);
            string result = null;
            HttpWebRequest req = (HttpWebRequest)HttpWebRequest.Create(url);
            req.Headers.Add("Authorization", txtAuthKey.Text);
            req.ContentType = "application/json";
            req.Method = "POST";
            req.ContentLength = bytesToPost.Length;

            using (Stream reqStream = req.GetRequestStream())
            {
                reqStream.Write(bytesToPost, 0, bytesToPost.Length);
            }
            HttpWebResponse res = (HttpWebResponse)req.GetResponse();
            if (res != null)
            {
                StreamReader sr;
                using (sr = new StreamReader(res.GetResponseStream()))
                {
                    result = sr.ReadToEnd();
                }
                sr.Close();
            }
            res.Close();
            return result;
        }

        DataTable table = null;

        private void YRP2Video_Load(object sender, EventArgs e)
        {
            try
            {
                DataSet ds = new DataSet();
                ds.ReadXml("yrp2video.conf");
                if (ds.Tables.Count < 1)
                {
                    throw new Exception();
                }
                table = ds.Tables[0].Copy();
                ds.Dispose();
            }
            catch
            {
                table = new DataTable();
                table.Columns.Add("文件名");
                table.Columns.Add("ID");
                table.Columns.Add("转换情况");
                table.Columns.Add("其他信息");
                table.Columns.Add("完成时间");
            }
            dgvData.DataSource = table;
            txtAuthKey.Text = Properties.Settings.Default.AuthKey;
            txtApiUrl.Text = Properties.Settings.Default.ApiUrl;
            init = true;

        }

        private JavaScriptSerializer json = new JavaScriptSerializer();
        private string JSONEncode(object obj)
        {
            return this.json.Serialize(obj);
        }

        private T JSONDecode<T>(string str)
        {
            return this.json.Deserialize<T>(str);
        }

        private string JSONEncode(object obj, string pass)
        {
            string result = this.json.Serialize(obj);
            return this.Encryption(result, pass);
        }

        private T JSONDecode<T>(string str, string pass)
        {
            str = Decryption(str, pass);
            return this.json.Deserialize<T>(str);
        }

        private string Encryption(string str, string key = "aaaaaaaaaaaaaaaa")
        {
            if (string.IsNullOrEmpty(str))
            {
                return null;
            }

            byte[] toEncryptArray = Encoding.UTF8.GetBytes(str);

            RijndaelManaged rm = new RijndaelManaged
            {
                Key = Encoding.UTF8.GetBytes(key),
                Mode = CipherMode.ECB,
                Padding = PaddingMode.PKCS7
            };

            ICryptoTransform cTransform = rm.CreateEncryptor();
            byte[] resultArray = cTransform.TransformFinalBlock(toEncryptArray, 0, toEncryptArray.Length);

            return Convert.ToBase64String(resultArray, 0, resultArray.Length).Replace("/", "_").Replace("+", "-");
        }

        public static string Decryption(string str, string key = "aaaaaaaaaaaaaaaa")
        {
            str = str.Replace("_", "/").Replace("-", "+");
            if (string.IsNullOrEmpty(str))
            {
                return null;
            }

            byte[] toEncryptArray = Convert.FromBase64String(str);

            RijndaelManaged rm = new RijndaelManaged
            {
                Key = Encoding.UTF8.GetBytes(key),
                Mode = CipherMode.ECB,
                Padding = PaddingMode.PKCS7
            };

            ICryptoTransform cTransform = rm.CreateDecryptor();
            byte[] resultArray = cTransform.TransformFinalBlock(toEncryptArray, 0, toEncryptArray.Length);

            return Encoding.UTF8.GetString(resultArray);
        }
        private void DownloadFile(string url, string fileName, ToolStripProgressBar pb, ToolStripLabel lb)
        {
            Stream st = null;
            Stream so = null;
            FileInfo fi = new FileInfo(fileName);
            if (!fi.Directory.Exists)
            {
                Directory.CreateDirectory(fi.Directory.FullName);
            }
            try
            {

                HttpWebRequest Myrq = (HttpWebRequest)WebRequest.Create(url);
                HttpWebResponse myrp = (HttpWebResponse)Myrq.GetResponse();

                long totalBytes = myrp.ContentLength;
                pb.Maximum = (int)totalBytes;

                st = myrp.GetResponseStream();
                so = new FileStream(fileName, FileMode.Create);

                long totalDownloadedByte = 0;
                byte[] by = new byte[1024 * 512];
                int osize = st.Read(by, 0, by.Length);
                while (osize > 0)
                {
                    totalDownloadedByte = osize + totalDownloadedByte;
                    Application.DoEvents();
                    so.Write(by, 0, osize);
                    if (pb != null)
                    {
                        pb.Value = (int)totalDownloadedByte;
                    }
                    osize = st.Read(by, 0, by.Length);
                    float percent = totalDownloadedByte / (float)totalBytes * 100;
                    lb.Text = $"正在下载 {fileName} :" + Math.Round(percent, 2).ToString().PadLeft(6) + "%";
                    Application.DoEvents();
                }
                if (pb != null)
                {
                    pb.Value = pb.Maximum;
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            finally
            {
                so?.Close();
                st?.Close();
            }
        }

        private void btnAddFile_Click(object sender, EventArgs e)
        {
            if (ofdOpen.ShowDialog() == DialogResult.OK)
            {
                foreach(string file in ofdOpen.FileNames)
                {
                    this.AddFile(file);
                }
            }
            this.SaveToFile();
        }
        private void RefreshRow(ref DataRow row, string json)
        {
            Result res = this.JSONDecode<Result>(json);
            if (!res.success)
            {
                return;
            }
            row["ID"] = res;
            switch (res.task.status)
            {
                case "finished":
                    row["转换情况"] = "已完成";
                    break;
                case "running":
                    row["转换情况"] = "运行中";
                    break;
                case "pending":
                    row["转换情况"] = "等待中";
                    break;
                case "queue":
                    row["转换情况"] = "队列中";
                    break;
                default:
                    row["转换情况"] = res.task.status;
                    break;
            }
            row["其他信息"] = res.task.failMessage != null ? "失败：" + res.task.failMessage : "";
            row["完成时间"] = res.task.completeTime != null ? res.task.completeTime : "N/A";
            Application.DoEvents();
        }

        private void AddFile(string file)
        {
            lbStatus.Text = "正在添加任务：" + file;
            Application.DoEvents();
            DataRow row = table.NewRow();
            /*
                table.Columns.Add("文件名");
                table.Columns.Add("ID");
                table.Columns.Add("转换情况");
                table.Columns.Add("其他信息");
                table.Columns.Add("完成时间"); */
            row["文件名"] = new FileInfo(file).Name;

            string base64 = this.ToBase64(file);
            Replay rep = new Replay()
            {
                replay = base64
            };
            string url = "https://yunomi.mycard.moe/video/task";
            try
            {
                string result = this.HttpPost(url, this.JSONEncode(rep));
                this.RefreshRow(ref row, result);
            }
            catch(Exception ex)
            {
                MessageBox.Show($"文件{file}添加失败，错误信息：{ex.Message}", "错误");
                return;
            }
            table.Rows.Add(row);
            lbStatus.Text = "就绪";
            Application.DoEvents();
        }

        private void YRP2Video_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.All;
        }

        private void YRP2Video_DragDrop(object sender, DragEventArgs e)
        {
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
            foreach(string file in files)
            {
                if (Directory.Exists(file))
                {
                    foreach (string f in Directory.EnumerateFiles(file, "*.yrp", SearchOption.AllDirectories))
                    {
                        this.AddFile(f);
                    }
                }
                else if (file.ToLower().EndsWith(".yrp"))
                {
                    this.AddFile(file);
                }
            }
            this.SaveToFile();
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            List<string> shouldDelete = new List<string>();
            for(int i=0;i<dgvData.Rows.Count; i++)
            {
                if (dgvData.Rows[i].Cells["ID"].Value == null)
                {
                    continue;
                }
                if ((dgvData.Rows.GetRowState(i) & DataGridViewElementStates.Selected) > 0)
                {
                    shouldDelete.Add(dgvData.Rows[i].Cells["ID"].Value.ToString());
                }
            }
            int count = table.Rows.Count - 1;
            for(; count > -1; count--)
            {
                if (shouldDelete.Contains(table.Rows[count]["ID"].ToString()))
                {
                    table.Rows.RemoveAt(count);
                }
            }
            this.SaveToFile();
        }
        private void SaveToFile()
        {
            DataSet ds = new DataSet();
            ds.Tables.Add(table.Copy());
            ds.WriteXml("yrp2video.conf");
            ds.Dispose();
        }

        private void btnRefresh_Click(object sender, EventArgs e)
        {
            for(int i = 0; i < table.Rows.Count; i++)
            {
                try
                {
                    string id = table.Rows[i]["ID"].ToString();
                    if (string.IsNullOrEmpty(id))
                    {
                        continue;
                    }
                    string url = $"{txtApiUrl.Text}/video/task?id={id}";
                    string json = this.HttpGet(url);
                    DataRow row = table.Rows[i];
                    this.RefreshRow(ref row, json);
                }
                catch { }
            }
            this.SaveToFile();
        }

        private void btnDownload_Click(object sender, EventArgs e)
        {
            bool single = false;
            if (dgvData.SelectedRows.Count > 1)
            {
                if (fbdSave.ShowDialog() != DialogResult.OK)
                {
                    return;
                }
            }
            else
            {
                single = true;
                if (sfdSave.ShowDialog() != DialogResult.OK)
                {
                    return;
                }
            }
            for(int i = 0; i < dgvData.Rows.Count; i++)
            {
                if ((dgvData.Rows.GetRowState(i) & DataGridViewElementStates.Selected) == 0)
                {
                    continue;
                }
                string fileName = ((string)dgvData.Rows[i].Cells["文件名"].Value);
                if (single)
                {
                    fileName = sfdSave.FileName;
                }
                else
                {
                    fileName = fbdSave.SelectedPath + "\\" + fileName + ".mp4";
                }
                string dLink = this.GetDownloadLinkWithId(dgvData.Rows[i].Cells["ID"].Value.ToString());
                if (dLink != null)
                {
                    pbDownload.Visible = true;
                    this.DownloadFile(dLink, fileName, pbDownload, lbStatus);
                    pbDownload.Visible = false;
                    lbStatus.Text = "就绪";
                }
            }
        }
        private string GetDownloadLinkWithId(string id)
        {
            try
            {
                string url = $"https://yunomi.mycard.moe/video/task?id={id}";
                string json = this.HttpGet(url);
                Result res = this.JSONDecode<Result>(json);
                return res.task.downloadLink;
            }
            catch { }
            return null;
        }

        bool init = false;
        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (init)
            {
                Properties.Settings.Default.AuthKey = txtAuthKey.Text;
                Properties.Settings.Default.Save();
            }
        }

        private void txtApiUrl_TextChanged(object sender, EventArgs e)
        {
            if (init)
            {
                Properties.Settings.Default.ApiUrl = txtApiUrl.Text;
                Properties.Settings.Default.Save();
            }
        }
    }
    public class Replay
    {
        public string replay;
    }
    public class Result
    {
        public bool success;
        public ReplayTask task;
        public override string ToString()
        {
            return task.id;
        }
    }
    public class ReplayTask
    {
        public string id;
        public string replayContent;
        public string status;
        public string downloadLink;
        public string failMessage;
        public string completeTime;
        public override string ToString()
        {
            return id;
        }
    }
}
