﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Script.Serialization;
using System.Windows.Forms;

namespace WBJsonGenerator
{
    public partial class WBJsonGenerator : Form
    {
        public WBJsonGenerator()
        {
            this.InitializeComponent();
        }

        Dictionary<string,List<string>> dic = new Dictionary<string, List<string>>();
        private void listJsonType_SelectedIndexChanged(object sender, EventArgs e)
        {
            listJsonString.Items.Clear();
            if (listJsonType.SelectedIndex < 0)
            {
                return;
            }
            foreach (string str in dic[listJsonType.SelectedItem.ToString().Split('|')[0]])
            {
                listJsonString.Items.Add(str);
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            foreach(string str in listJsonType.Items)
            {
                dic.Add(str.Split('|')[0], new List<string>());
            }
            listJsonType.SelectedIndex = 0;
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            if (listJsonType.SelectedItem == null)
            {
                return;
            }
            dic[listJsonType.SelectedItem.ToString().Split('|')[0]].Add(txtString.Text);
            listJsonString.Items.Add(txtString.Text);
        }

        private void btnDeleteSelected_Click(object sender, EventArgs e)
        {
            if (listJsonType.SelectedItem == null)
            {
                return;
            }
            for (int i = listJsonString.Items.Count; i >= 0; i--)
            {
                if (listJsonString.SelectedIndices.Contains(i))
                {
                    dic[listJsonType.SelectedItem.ToString().Split('|')[0]].RemoveAt(i);
                    listJsonString.Items.RemoveAt(i);
                }
            }
        }
        JavaScriptSerializer jss = new JavaScriptSerializer();

        private void btnSave_Click(object sender, EventArgs e)
        {
            Dictionary<string, object> newDic = new Dictionary<string, object>();
            foreach(var kvp in dic)
            {
                if (kvp.Value.Count < 1)
                {
                    MessageBox.Show($"错误：{kvp.Key}尚未填写，无法保存。");
                    return;
                }
                if (kvp.Key == "facedownmonstername")
                {
                    if (kvp.Value.Count > 1)
                    {
                        MessageBox.Show($"错误：{kvp.Key}里只能填写一个称呼。");
                        return;
                    }
                    else
                    {
                        newDic.Add(kvp.Key, kvp.Value[0]);
                        continue;
                    }
                }
                newDic.Add(kvp.Key, kvp.Value);
            }
            if (sfdJson.ShowDialog() == DialogResult.OK)
            {
                File.WriteAllText(sfdJson.FileName,jss.Serialize(newDic));
            }
        }

        private void btnLoad_Click(object sender, EventArgs e)
        {
            ofdJson.InitialDirectory = Environment.CurrentDirectory;
            if (ofdJson.ShowDialog() == DialogResult.OK)
            {
                string content = File.ReadAllText(ofdJson.FileName);
                object ooo = jss.DeserializeObject(content);
                var obj = jss.Deserialize<Dictionary<string, object>>(content);
                dic.Clear();
                foreach(var kvp in obj)
                {
                    if (kvp.Key == "facedownmonstername")
                    {

                    }
                    dic.Add(kvp.Key, new List<string>());
                    if (kvp.Value is string)
                    {
                        dic[kvp.Key].Add(kvp.Value.ToString());
                    }
                    else
                    {
                        foreach (string o in kvp.Value as ArrayList)
                        {
                            dic[kvp.Key].Add(o);
                        }
                    }
                }
                listJsonType.SelectedIndex = -1;
                listJsonString.Items.Clear();
            }
        }
    }
}
