﻿using System;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Collections.Generic;

class Program
{
    public static void Main(string[] args)
    {
        var tuple = GetSrvInfoForYgopro("duels.link");
        string host = tuple.Item1;
        int port = tuple.Item2;
        Console.WriteLine($"{host},{port}");
        Console.ReadKey();
    }
    public static (string,int) GetSrvInfoForYgopro(string host)
    {
        //添加ygopro前缀
        host = $"_ygopro._tcp.{host}";
        //DNS服务器
        string dnsServer = "114.114.114.114";
        //DNS服务器端口
        int dnsPort = 53;

        //发送的数据
        byte[] req = CreateRequestData(host);

        byte[]? res = null;
        UdpClient udp = new UdpClient(dnsServer, dnsPort);
#if DEBUG
        Console.WriteLine("Request string:");
        Console.WriteLine(BitConverter.ToString(req));
#endif
        //发送数据
        udp.Send(req, req.Length);
        //接收数据
        IPEndPoint? ep = null;
        res = udp.Receive(ref ep);
#if DEBUG
        Console.WriteLine("Respond string:");
        Console.WriteLine(BitConverter.ToString(res));
        for (int index = 0; index < res.Length; index++)
        {
            Console.WriteLine($"{index} {(char)(res[index])} {(int)res[index]}");
        }
#endif
        //返回的数据头很长，与发送的数据长度相同。
        //数据头之后，第16字节~17字节为2字节的端口号。
        int resPort = res[req.Length + 16] * 256 + res[req.Length + 17];
        //第18字节开始，是
        //1字节的short，表示下一段host字符串的长度 -> 一段host的string -> 1字节的short，表示下一段host字符串的长度 -> 一段host的string……
        //直到长度==0为止
        int start = req.Length + 18;
        int nextLen = res[start];
        string resHost = "";
        while (nextLen > 0)
        {
            int now = 0;
            for (; now < nextLen; now++)
            {
                resHost += (char)res[start + now + 1];
            }
            resHost += ".";
            start = start + now + 1;
            nextLen = res[start];
        }
        resHost = resHost.Substring(0, resHost.Length - 1);
        //拼接host

        return (resHost,resPort);
    }
    private static byte[] CreateRequestData(string qName)
    {
        MemoryStream ms = new MemoryStream();

        //参考资料： https://datatracker.ietf.org/doc/html/rfc2782 RFC2782
        WriteBytes(0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0);

        string[] buffs = qName.Split('.');
        foreach (string s in buffs)
        {
            byte[] b = Encoding.UTF8.GetBytes(s);
            ms.WriteByte((byte)b.Length);
            ms.Write(b, 0, b.Length);
        }
        WriteBytes(0, 0, 33, 0, 1); //srv lookup:33
        return ms.ToArray();

        void WriteBytes(params byte[] bytes)
        {
            for(int i=0;i<bytes.Length; i++)
            {
                ms.WriteByte(bytes[i]);
            }
        }
    }
}