﻿using Microsoft.Data.Sqlite;
namespace PixivNovelServer
{
    public static class SqliteService
    {
        public static string Server = "novel.db";
        public static bool Inited = false;
        public static string LastError = "";
        static SqliteTransaction? clientTransaction = null;

        static SqliteConnection? client = null;

        static public void ChangeDatabase(string database)
        {
            if (client == null)
            {
                Inited = true;
                client = GetConnection();
            }
            client!.ChangeDatabase(database);
        }

        static public SqliteTransaction BeginTransaction()
        {
            client = GetConnection();
            var conn = clientTransaction?.Connection;
            try
            {
                clientTransaction?.Dispose();
                conn?.Dispose();
            }
            catch { }
            clientTransaction = client.BeginTransaction();
            return clientTransaction;
        }

        static public void Setting(string server, int port, string user, string password, string database)
        {
            Server = server;
            client = GetConnection();
            Inited = true;
        }

        static public SqliteConnection GetConnection()
        {
            var c = new SqliteConnection($"Data Source={Server};");
            c.Open();
            return c;
        }

        public static void Execute(string cmd, params object[] args)
        {
            try
            {
                using SqliteConnection conn = GetConnection();
                using SqliteCommand command = new(cmd, conn);
                foreach (var par in args)
                {
                    SqliteParameter p = new()
                    {
                        Value = par
                    };
                    command.Parameters.Add(p);
                }
                command.ExecuteNonQuery();
            }
            catch (Exception ex)
            {
                LastError = ex.ToString();
            }
        }

        public static async Task<int> ExecuteAsync(string cmd, params object[] args)
        {
            try
            {
                using SqliteConnection conn = GetConnection();
                using SqliteCommand command = new(cmd, conn);
                foreach (var par in args)
                {
                    SqliteParameter p = new()
                    {
                        Value = par
                    };
                    command.Parameters.Add(p);
                }
                return await command.ExecuteNonQueryAsync();
            }
            catch (Exception ex)
            {
                LastError = ex.ToString();
            }

            return 0;
        }

        public static void ExecuteTrans(string cmd, SqliteTransaction trans, params object[] args)
        {
            try
            {
                using SqliteCommand command = new(cmd, trans.Connection, trans);
                foreach (var par in args)
                {
                    SqliteParameter p = new()
                    {
                        Value = par
                    };
                    command.Parameters.Add(p);
                }
                command.ExecuteNonQuery();
            }
            catch (Exception ex)
            {
                LastError = ex.ToString();
            }
        }
        public async static Task<bool> ExecuteTransAsync(string cmd, SqliteTransaction trans, params object[] args)
        {
            try
            {
                using SqliteCommand command = new(cmd, trans.Connection, trans);
                int i = 1;
                foreach (var par in args)
                {
                    SqliteParameter p = new()
                    {
                        Value = par
                    };
                    command.Parameters.AddWithValue($"@p{i}", par);
                    i++;
                }
                await command.ExecuteNonQueryAsync();
            }
            catch (Exception ex)
            {
                LastError = ex.ToString();
                return false;
            }
            return true;
        }

        public static async void DisposeReader(SqliteDataReader? reader)
        {
            if (reader == null)
            {
                return;
            }
            await reader.DisposeAsync();
            if (readerDic.ContainsKey(reader))
            {
                var conn = readerDic[reader];
                await reader.DisposeAsync();
                await conn.DisposeAsync();
            }
        }

        static Dictionary<SqliteDataReader, SqliteConnection> readerDic = new();

        public static SqliteDataReader? GetReader(string sqlCommand, params object[] pars)
        {
            try
            {
                SqliteConnection conn = GetConnection();
                SqliteCommand command = new(sqlCommand, conn);
                int index = 1;
                if (pars.Length > 0)
                {
                    command.Parameters.Clear();
                    foreach (var par in pars)
                    {
                        command.Parameters.AddWithValue($"@p{index}",par);
                        index++;
                    }
                }
                var reader = command.ExecuteReader(System.Data.CommandBehavior.CloseConnection);
                readerDic[reader] = conn;
                return reader;
            }
            catch (Exception ex)
            {
                LastError = ex.ToString();
            }
            return null;
        }

        public static object? GetValue(string sqlCommand, params object[] pars)
        {
            try
            {
                using SqliteConnection conn = GetConnection();
                using SqliteCommand command = new(sqlCommand, conn);
                if (pars.Length > 0)
                {
                    command.Parameters.Clear();
                    foreach (var par in pars)
                    {
                        command.Parameters.Add(new SqliteParameter() { Value = par });
                    }
                }
                var reader = command.ExecuteReader();
                if (!reader.Read())
                {
                    return null;
                }
                var result = reader.GetValue(0);
                reader.Dispose();
                command.Dispose();
                conn.Dispose();
                return result;
            }
            catch (Exception ex)
            {
                LastError = ex.ToString();
            }
            return null;
        }


        public static async Task<object?> GetValueAsync(string sqlCommand, params object[] pars)
        {
            try
            {
                using SqliteConnection conn = GetConnection();
                using SqliteCommand command = new(sqlCommand, conn);
                if (pars.Length > 0)
                {
                    command.Parameters.Clear();
                    foreach (var par in pars)
                    {
                        command.Parameters.Add(new SqliteParameter() { Value = par });
                    }
                }
                var reader = await command.ExecuteReaderAsync();
                if (!await reader.ReadAsync())
                {
                    return null;
                }
                var result = reader.GetValue(0);
                await reader.DisposeAsync();
                await command.DisposeAsync();
                await conn.DisposeAsync();
                return result;
            }
            catch (Exception ex)
            {
                LastError = ex.ToString();
            }
            return null;
        }

        static public SqliteDataReader? GetTransReader(string sqlCommand, SqliteTransaction trans, params object[] pars)
        {
            try
            {
                using SqliteCommand command = new(sqlCommand, trans.Connection, trans);
                if (pars.Length > 0)
                {
                    command.Parameters.Clear();
                    foreach (var par in pars)
                    {
                        command.Parameters.Add(new SqliteParameter() { Value = par });
                    }
                }
                return command.ExecuteReader();
            }
            catch (Exception ex)
            {
                LastError = ex.ToString();
            }
            return null;
        }
    }
}
