-- 拓扑混沌交换熊 
local s,id,o=GetID()
function s.initial_effect(c)
	--link summon
	aux.AddLinkProcedure(c,aux.FilterBoolFunction(Card.IsLinkType,TYPE_EFFECT),2,2)
	c:EnableReviveLimit()
	-- destro
	local e1=Effect.CreateEffect(c)
	e1:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_CONTINUOUS)
	e1:SetCode(EVENT_BECOME_TARGET)
	e1:SetRange(LOCATION_MZONE)
	e1:SetCondition(s.destrocon)
	e1:SetOperation(s.destroop)
	c:RegisterEffect(e1)
	-- skip M2
	local e2=Effect.CreateEffect(c)
	e2:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_CONTINUOUS)
	e2:SetCode(EVENT_ATTACK_ANNOUNCE)
	e2:SetRange(LOCATION_MZONE)
	e2:SetCondition(s.skipcon)
	e2:SetOperation(s.skipop)
	c:RegisterEffect(e2)
	-- immune effect
	local e3=Effect.CreateEffect(c)
	e3:SetType(EFFECT_TYPE_FIELD)
	e3:SetCode(EFFECT_IMMUNE_EFFECT)
	e3:SetRange(LOCATION_MZONE)
	e3:SetTarget(s.immunetg)
	e3:SetValue(s.immunefilter)
	e3:SetTargetRange(LOCATION_ONFIELD,LOCATION_ONFIELD)
	c:RegisterEffect(e3)
	-- win
	local e4=Effect.CreateEffect(c)
	e4:SetType(EFFECT_TYPE_SINGLE+EFFECT_TYPE_CONTINUOUS)
	e4:SetRange(LOCATION_REMOVED)
	e4:SetCode(EVENT_REMOVE)
	e4:SetCondition(s.wincon)
	e4:SetOperation(s.winop)
	c:RegisterEffect(e4)
end
function s.linkfilter(c)
	return c:IsCode(47297616) and c:GetAttack()==2800
end
function s.destrocon(e,tp,eg,ep,ev,re,r,rp)
	if #eg~=1 then return false end
	local c=e:GetHandler()
	local mg=c:GetMutualLinkedGroup()
	if #mg>0 then return false end
	local g=c:GetLinkedGroup()
	local tc=eg:GetFirst()
	return tc==c or g:IsContains(tc)
end
function s.destrofilter(c,ftg,e,tp,eg,ep,ev,re,r,rp)
	return ftg(e,tp,eg,ep,ev,re,r,rp,0,c)
end
function s.destroop(e,tp,eg,ep,ev,re,r,rp)
	local fop=re:GetOperation()
	local ftg=re:GetTarget()
	local c=e:GetHandler()
	local g=c:GetLinkedGroup()
	g:AddCard(c)
	g=g:Filter(s.destrofilter,nil,ftg,e,tp,eg,ep,ev,re,r,rp)
	g:KeepAlive()
	Duel.Hint(HINT_CARD,0,id)
	Duel.HintSelection(g)
	--Duel.ChangeTargetCard(ev,g:Clone())
	Duel.ChangeChainOperation(ev,s._destroop(fop,g))
end

function s._destroop(op,g)
	return function(e,tp,eg,ep,ev,re,r,rp)
		local rg=s.shuffle(g)
		for _, tc in ipairs(rg) do
			local tg=Group.FromCards(tc)
			Duel.ChangeTargetCard(ev,tg)
			op(e,tp,eg,ep,ev,re,r,rp)
			tc=g:GetNext()
		end
	end
end

function s.shuffle(g)
	local c=g:GetFirst()
	local t={}
	while c do 
		table.insert(t,c)
		c=g:GetNext()
	end
	for i=#t,2,-1 do
		local j = math.random(i)
		t[i],t[j]=t[j],t[i]
	end
	return t
end

function s.skipcon(e,tp,eg,ep,ev,re,r,rp)
	return Duel.GetAttacker():GetOwner()==tp
end
function s.skipop(e,tp,eg,ep,ev,re,r,rp)
	Duel.SkipPhase(tp,PHASE_MAIN2,RESET_PHASE+PHASE_END,1)
end

function s.immunetg(e,c)
	local tp=c:GetControler()
	local ct=Duel.GetFieldGroupCount(tp,0,LOCATION_EXTRA)
	return ct>0 and ct<10
end
function s.immunefilter(e,re)
	return e:GetHandlerPlayer()~=re:GetOwnerPlayer()
end

function s.wincon(e,tp,eg,ep,ev,re,r,rp)
	local c=e:GetHandler()
	print(c:IsReason(REASON_EFFECT),rp,tp,c:IsPreviousControler(tp),c:IsPreviousLocation(LOCATION_ONFIELD),c:IsPreviousPosition(POS_FACEUP))
	return c:IsReason(REASON_EFFECT) and rp==1-tp and c:IsPreviousControler(tp)
		and c:IsPreviousLocation(LOCATION_ONFIELD) and c:IsPreviousPosition(POS_FACEUP) 
		and c:IsLocation(LOCATION_REMOVED) and c:IsPosition(POS_FACEDOWN)
end
function s.winop(e,tp,eg,ep,ev,re,r,rp)
	Duel.Win(tp,0xf0)
end